/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

class Application
implements Metadata {
    private static final Logger log = Logger.getLogger(Application.class);
    private final int APPLICATION_ID = 1;
    private int size;
    ValidationService service;
    FlacDescriptionWriter writer;

    public Application(int sizeInBytes, ValidationService service) {
        this.size = sizeInBytes;
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Application block: Checking data");
        String ID = "";
        String appName = "";
        for (int i = 0; i < 4; ++i) {
            int letter = provider.bigEndianBytesAsInt(1);
            ID = ID + Integer.toHexString(letter);
            appName = appName + (char)letter;
        }
        log.trace((Object)("Application ID: " + ID + " Name " + appName));
        provider.skipBytes(this.size - 4);
        this.writer.writeApplicationBlock(this.size);
    }
}

