/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.blocks.BlockFactory;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MetaHeader {
    private static final Logger log = Logger.getLogger(MetaHeader.class);
    private static final int LAST_BLOCK_FLAG = 1;
    private static final int BLOCK_TYPE = 7;
    private static final int SIZE_BYTES = 3;
    private int lastBlockFlag = 0;
    private int blockType;
    private int sizeInBytes;
    private int block = 0;
    ValidationService service;
    FlacDescriptionWriter writer;

    public MetaHeader(ValidationService service) {
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    public void check() throws IOException, AudioDescriptionException {
        while (this.lastBlockFlag != 1) {
            log.trace((Object)"New metadata block");
            this.initializeAndCheck();
        }
    }

    private void init(Provider provider) throws IOException {
        this.lastBlockFlag = provider.bitsAsInt(1);
        this.blockType = provider.bitsAsInt(7);
        this.sizeInBytes = provider.bigEndianBytesAsInt(3);
        log.trace((Object)("last block flag is " + this.lastBlockFlag + " size " + this.sizeInBytes + " type " + this.blockType));
    }

    private void checkHeader(Provider provider) throws IOException, AudioDescriptionException {
        if (this.blockType > 6) {
            this.service.errorOn(true, "Invalid block type: " + this.blockType + " in metadata header for block #" + this.block + ". 0 through 6 allowed");
            provider.skipBytes(this.sizeInBytes);
        } else {
            this.checkBlock(provider);
        }
    }

    private void initializeAndCheck() throws IOException, AudioDescriptionException {
        Provider provider = this.service.getProvider();
        this.init(provider);
        this.checkHeader(provider);
    }

    private void checkBlock(Provider provider) throws IOException, AudioDescriptionException {
        ++this.block;
        BlockFactory.getBlock(this.blockType, this.sizeInBytes, this.service).checkBlock(provider);
    }
}

