/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.Residuals;

import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Residual {
    private static final Logger log = Logger.getLogger(Residual.class);
    private static final int PARTITION_ORDER = 4;
    private static final int BITS_PER_SAMPLE = 5;
    private int order;
    private int parameterLength;
    private int numberOfSamples;
    private int blockSize;

    public Residual(int order, int type, int blockSize) {
        this.blockSize = blockSize;
        this.order = order;
        this.parameterLength = type == 0 ? 4 : 5;
    }

    public void check(Provider provider) throws IOException {
        int partition_order = provider.bitsAsInt(4);
        int partitions = 1 << partition_order;
        log.trace((Object)("Partition order is: " + partition_order + ". Checking " + partitions + " rice partitions"));
        for (int i = 0; i < partitions; ++i) {
            this.numberOfSamples = this.blockSize >> partition_order;
            int parameter = provider.bitsAsInt(this.parameterLength);
            if (partition_order == 0) {
                this.numberOfSamples = this.blockSize - this.order;
            } else if (i == 0) {
                this.numberOfSamples -= this.order;
            }
            if (parameter == 15 && this.parameterLength == 4 || parameter == 31 && this.parameterLength == 5) {
                provider.skipBits(provider.bitsAsInt(5) * this.numberOfSamples);
                continue;
            }
            this.skipResiduals(provider, this.numberOfSamples, parameter);
        }
    }

    private void skipResiduals(Provider provider, int samples, int param) throws IOException {
        for (int res = 0; res < samples; ++res) {
            while (provider.bitsAsInt(1) == 0) {
            }
            if (param == 0) continue;
            provider.skipBits(param);
        }
    }
}

