/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata.frametypes;

import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.flac.audiodata.AudioFrame;
import com.apple.jingle.leghorn.audio.flac.audiodata.FrameInformation;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.Residuals.Residual;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LPC
implements AudioFrame {
    private static final Logger log = Logger.getLogger(LPC.class);
    private static final int PRECISION = 4;
    private static final int SHIFT = 5;
    private static final int RICE_TYPE = 2;
    private int lpc_order;

    public LPC(int order) {
        this.lpc_order = order;
    }

    @Override
    public void checkFrame(FrameInformation frameInfo, FlacValidationService service, Provider provider) throws IOException {
        provider.skipBits(frameInfo.getBitDepth() * this.lpc_order);
        int LPC_precision = provider.bitsAsInt(4) + 1;
        service.warnOn(LPC_precision > 15, "Invalid LPC_precision: " + LPC_precision);
        int shift = provider.bitsAsInt(5);
        provider.skipBits(LPC_precision * this.lpc_order);
        int riceType = provider.bitsAsInt(2);
        service.warnOn(riceType > 1, "Invalid or reserved value for residual type. Types 2 and 3 are reserved. Frame " + frameInfo.getFrameCount());
        log.debug((Object)("Predictor order: " + this.lpc_order + ", Coefficient precision " + LPC_precision + ", Quantization: " + shift + ", ricetype " + riceType));
        new Residual(this.lpc_order, riceType, frameInfo.getBlockSize()).check(provider);
    }
}

