/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata.frametypes;

import com.apple.jingle.leghorn.audio.flac.audiodata.AudioFrame;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.Constant;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.Fixed;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.LPC;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.Verbatim;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.media.MediaValidationCode;

public class FrameFactory {
    public static AudioFrame getFrame(int type) throws AudioDescriptionException {
        if (type == 0) {
            return new Constant();
        }
        if (type == 1) {
            return new Verbatim();
        }
        if (type > 1 && type < 8) {
            throw new AudioDescriptionException("SubFrame type is not defined or reserved. Type : " + type, MediaValidationCode.AUD_APPEARS_CORRUPT);
        }
        if (type > 7 && type < 16) {
            int order = type & 7;
            if (order <= 4) {
                return new Fixed(order);
            }
            throw new AudioDescriptionException("SubFrame type is not defined or reserved. Type : " + type, MediaValidationCode.AUD_APPEARS_CORRUPT);
        }
        if (type > 15 && type < 32) {
            throw new AudioDescriptionException("SubFrame type is not defined or reserved. Type : " + type, MediaValidationCode.AUD_APPEARS_CORRUPT);
        }
        int order = (type & 0x1F) + 1;
        return new LPC(order);
    }
}

