/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata;

import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SubframeHeader {
    private static final Logger log = Logger.getLogger(SubframeHeader.class);
    private static final int ZERO_BIT_PADDING = 1;
    private static final int SUBFRAME_TYPE = 6;
    private static final int WASTED_BITS_PER_SAMPLE_FLAG = 1;
    private FlacValidationService service;
    private Provider provider;
    private int subFrameType;
    private int wastedBitsPerSample;

    public void init(FlacValidationService service, Provider provider) throws IOException {
        service.errorOn(provider.bitsAsInt(1) != 0, "First bit in sub-frame headers must be zero to prevent sync fooling.");
        this.subFrameType = provider.bitsAsInt(6);
        this.wastedBitsPerSample = provider.bitsAsInt(1);
        if (this.wastedBitsPerSample == 1) {
            while (provider.bitsAsInt(1) == 0) {
                ++this.wastedBitsPerSample;
            }
        }
        log.trace((Object)("Subframe type: " + this.subFrameType));
    }

    public int getSubFrameType() {
        return this.subFrameType;
    }

    public int getWastedBitsPerSample() {
        return this.wastedBitsPerSample;
    }
}

