/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata;

import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.flac.audiodata.FrameInformation;
import com.apple.jingle.leghorn.audio.flac.audiodata.SubframeHeader;
import com.apple.jingle.leghorn.audio.flac.audiodata.frametypes.FrameFactory;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;

public class Subframe {
    private SubframeHeader header;
    private int subframeType;
    private int channels;
    private FlacValidationService service;
    private FrameInformation frameInfo;

    public Subframe(int channels, FlacValidationService service) {
        this.channels = channels;
        this.service = service;
    }

    public void check() throws IOException, AudioDescriptionException {
        Provider provider = this.service.getProvider();
        this.frameInfo = this.service.getFrameInfo();
        int diff = this.frameInfo.getDifference();
        int depth = this.frameInfo.getBitDepth();
        int waste = 0;
        for (int i = 0; i < this.channels; ++i) {
            this.header = new SubframeHeader();
            this.header.init(this.service, provider);
            waste = this.header.getWastedBitsPerSample();
            this.subframeType = this.header.getSubFrameType();
            this.frameInfo.setBitDepth(depth - waste);
            if (i == diff || diff == 2) {
                this.frameInfo.incrBitDepth();
                FrameFactory.getFrame(this.subframeType).checkFrame(this.frameInfo, this.service, provider);
                this.frameInfo.decrBitDepth();
            } else {
                FrameFactory.getFrame(this.subframeType).checkFrame(this.frameInfo, this.service, provider);
            }
            this.frameInfo.setBitDepth(depth + waste);
        }
    }
}

