/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.audiodata;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.flac.audiodata.FrameInformation;
import com.apple.jingle.leghorn.audio.flac.audiodata.Subframe;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FrameHeader {
    private static final Logger log = Logger.getLogger(FrameHeader.class);
    private static final int SYNC_CODE = 14;
    private static final int RESERVED = 1;
    private static final int BLOCKING_STRATEGY = 1;
    private static final int BLOCK_SIZE = 4;
    private static final int SAMPLE_RATE = 4;
    private static final int CHANNEL_INDEX = 4;
    private static final int SAMPLE_SIZE = 3;
    private static final int[] blockSizes = new int[]{0, 192, 576, 1152, 2304, 4608, -1, -2, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    private static final double[] sampleRates = new double[]{0.0, 88.2, 176.4, 192.0, 8.0, 16.0, 22.05, 24.0, 32.0, 44.1, 48.0, 96.0, 12.0, 13.0, 14.0, -1.0};
    private static final String[] channels = new String[]{"1 channel: mono", "2 channels: left, right", "3 channels: left, right, center", "4 channels: left, right, back left, back right", "5 channels: left, right, center, back/surround left, back/surround right", "6 channels: left, right center, LFE, back/surround left, back/surround right", "7 channels: not defined", "8 channels: not defined", "left/side stereo: channel 0 is left, channel 1 is side (difference)", "right/side stereo: channel 0 is side (difference), channel 1 is right", "mid/side stereo: channel 0 is mid (average), channel 1 is side (difference)", "reserved"};
    private static final String[] subFrames = new String[]{"Undefined", "Constant", "Verbatim", "Fixed", "LPC"};
    private static final int[] sampleSizes = new int[]{0, 8, 12, -1, 16, 20, 24, -1};
    private int syncCode;
    private int frames;
    private int blockingStrategy;
    private int blockSize;
    private int channelIndex;
    private int channelCount;
    private int sampleSize;
    private int sampleNumber;
    private int frameCount;
    private int sampleFlag;
    private int header_crc;
    private int reserved1;
    private int reserved2;
    private boolean fixedBlocking;
    private boolean referenceFixedBlocking;
    private String channelAssignment;
    private double sampleRate;
    private double referenceSampleRate;
    private int difference;
    private FlacValidationService service;
    private FlacDescriptionWriter writer;
    private Provider provider;

    public FrameHeader(int frames, FlacValidationService service) {
        this.frames = frames;
        this.service = service;
        this.provider = service.getProvider();
        this.writer = service.getWriter();
    }

    public void check() throws IOException, AudioDescriptionException {
        while (true) {
            this.init();
            this.doChecks();
            this.writeFrameInfo();
            new Subframe(this.channelCount, this.service).check();
            this.provider.pad();
            this.provider.stopRecording();
            this.checkFrameFooter();
            ++this.frames;
        }
    }

    private void init() throws IOException {
        this.provider.startRecording();
        this.syncCode = this.provider.bitsAsInt(14);
        this.reserved1 = this.provider.bitsAsInt(1);
        this.blockingStrategy = this.provider.bitsAsInt(1);
        this.blockSize = blockSizes[this.provider.bitsAsInt(4)];
        this.sampleRate = sampleRates[this.provider.bitsAsInt(4)];
        this.channelIndex = this.provider.bitsAsInt(4);
        this.channelAssignment = channels[this.channelIndex];
        this.fixedBlocking = this.blockingStrategy == 0;
        this.sampleSize = sampleSizes[this.provider.bitsAsInt(3)];
        this.reserved2 = this.provider.bitsAsInt(1);
        if (this.blockingStrategy == 1) {
            this.sampleNumber = this.decodeUTF();
            this.sampleFlag = 1;
        } else {
            this.frameCount = this.decodeUTF();
        }
        if (this.blockSize < 0) {
            this.blockSize = this.getBlockSizeFromEndOfHeader(this.blockSize);
        }
        if (this.sampleRate > 11.0 && this.sampleRate < 15.0) {
            this.sampleRate = this.getSampleRateFromEndOfHeader(this.sampleRate);
        }
        this.header_crc = this.provider.bigEndianBytesAsInt(1);
        this.channelCount = this.channelIndex > 7 && this.channelIndex < channels.length - 1 ? 2 : this.channelIndex + 1;
        this.difference = this.channelIndex == 9 ? 0 : (this.channelIndex == 8 || this.channelIndex == 10 ? 1 : -1);
        log.debug((Object)("Block size: " + this.blockSize + ", Blocking strategy: " + this.blockingStrategy + ", Sample Rate: " + this.sampleRate + "kHz" + ", sampleSize: " + this.sampleSize + "\n" + "Channels: " + this.channelCount + ", Channel assignment: " + this.channelAssignment));
    }

    private int getBlockSizeFromEndOfHeader(int size) throws IOException {
        if (size == -1) {
            return this.provider.bigEndianBytesAsInt(1) + 1;
        }
        return this.provider.bigEndianBytesAsInt(2) + 1;
    }

    private double getSampleRateFromEndOfHeader(double rate) throws IOException {
        if (rate == 12.0) {
            return this.provider.bigEndianBytesAsInt(1);
        }
        if (rate == 13.0) {
            return (double)this.provider.bigEndianBytesAsInt(2) / 1000.0;
        }
        return (double)this.provider.bigEndianBytesAsInt(2) / 100.0;
    }

    private void doChecks() {
        this.service.errorOn(this.syncCode != 16382, "Invalid sync code. Sync code bit sequence should be: 11111111111110 in frame " + this.frameCount);
        this.service.errorOn(this.reserved1 != 0 || this.reserved2 != 0, "Non-zero reserved bit. The bit immediately after the sync code is reserved and must be set to 0 in frame " + this.frames);
        if (this.frames == 0) {
            this.referenceSampleRate = this.sampleRate;
            this.referenceFixedBlocking = this.fixedBlocking;
        } else {
            this.service.errorOn(this.fixedBlocking != this.referenceFixedBlocking, "Blocking strategy must be the same across all frames: Frame " + this.frames);
            this.service.warnOn(this.sampleRate != this.referenceSampleRate, "Warning: Sample rate changes in audiodata frame " + this.frames + ".");
        }
    }

    private int decodeUTF() throws IOException {
        int result = 0;
        int thisByte = 0;
        int bytes = 1;
        while (this.provider.bitsAsInt(1) == 1) {
            ++bytes;
        }
        if (bytes == 1) {
            return this.provider.bitsAsInt(7);
        }
        --bytes;
        for (int i = 0; i < bytes; ++i) {
            thisByte = i == 0 ? this.provider.bitsAsInt(8 - (bytes + 1)) : this.provider.bitsAsInt(8) & 0x3F;
            result <<= 6;
            result += thisByte;
        }
        return result;
    }

    private void checkFrameFooter() throws IOException, AudioDescriptionException {
        int footer_crc = this.provider.bigEndianBytesAsInt(2);
        log.trace((Object)"Checking 16-bit CRC");
        this.provider.processCRC(footer_crc);
    }

    private void writeFrameInfo() {
        this.service.setFrameInfo(new FrameInformation(this.frames, this.blockingStrategy, this.blockSize, this.sampleRate, this.sampleSize, this.sampleNumber, this.channelCount, this.channelAssignment, this.header_crc, this.difference));
    }

    public int getFrame() {
        return this.frames;
    }
}

