/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.io.IOException;
import org.apache.log4j.Logger;

public class StreamHeader {
    private static final Logger log = Logger.getLogger(StreamHeader.class);
    private static final int FLAC_HEADER_BYTES = 4;
    private static final int fLaC = 1716281667;
    private int flacHeader;
    private ValidationService service;
    private FlacDescriptionWriter writer;

    public StreamHeader(ValidationService service) {
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    public void check() throws IOException, AudioDescriptionException {
        this.init();
        this.checkHeader();
    }

    private void init() throws IOException {
        this.setFlacHeader(this.service.getProvider().bigEndianBytesAsInt(4));
    }

    private void checkHeader() throws AudioDescriptionException {
        this.service.failOn(this.getFlacHeader() != 1716281667, "fLaC header not found", MediaValidationCode.AUD_CONTAINER_INCOMPATIBLE);
        log.trace((Object)"FLAC header verified");
        this.writer.writeFileHeader("fLaC");
    }

    private void setFlacHeader(int flacHeader) {
        this.flacHeader = flacHeader;
    }

    private int getFlacHeader() {
        return this.flacHeader;
    }
}

