/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.StreamHeader;
import com.apple.jingle.leghorn.audio.flac.StreamInformation;
import com.apple.jingle.leghorn.audio.flac.audiodata.FrameHeader;
import com.apple.jingle.leghorn.audio.flac.audiodata.FrameInformation;
import com.apple.jingle.leghorn.audio.flac.metadata.MetaHeader;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.DescriptionSetter;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FlacValidationService
extends ValidationService {
    private static final Logger log = Logger.getLogger(FlacValidationService.class);
    private StreamInformation streamInfo;
    private FrameInformation frameInfo;

    public FlacValidationService(SeekableDataInput sdi, ValidationListener listener, boolean locality, String uti, String type) {
        super(sdi, listener, locality, uti, type);
        this.setWriter((FlacDescriptionWriter)DescriptionSetter.setWriter(uti, type));
        this.attachToProvider();
    }

    @Override
    public void validate() throws AudioDescriptionException, IOException {
        new StreamHeader(this).check();
        new MetaHeader(this).check();
        new FrameHeader(0, this).check();
    }

    @Override
    public FlacDescriptionWriter getWriter() {
        return (FlacDescriptionWriter)this.writer;
    }

    public void setWriter(FlacDescriptionWriter flacWriter) {
        this.writer = flacWriter;
    }

    protected FlacValidationService() {
        this.attachToProvider();
    }

    private void attachToProvider() {
        this.getProvider().attach(this);
    }

    @Override
    public void eofReached() {
        this.setEof(true);
        this.getWriter().writeFileSize(this.getFileSize());
        this.finishUp();
    }

    public StreamInformation getStreamInfo() {
        return this.streamInfo;
    }

    public void setStreamInfo(StreamInformation streamInfo) {
        this.streamInfo = streamInfo;
    }

    public FrameInformation getFrameInfo() {
        return this.frameInfo;
    }

    public void setFrameInfo(FrameInformation frameInfo) {
        this.frameInfo = frameInfo;
    }

    @Override
    public int getFrame() {
        return this.frameInfo == null ? 0 : this.frameInfo.getFrameCount();
    }

    @Override
    public void finishUp() {
        super.finishUp();
        try {
            if (this.frameInfo != null) {
                String blockStrat = this.frameInfo.getBlockingStrategy() == 0 ? "Fixed" : "Variable";
                this.getWriter().writeFrames(this.frameInfo.getFrameCount(), blockStrat, this.frameInfo.getBlockSize(), "samples");
            } else {
                this.addError("Audio data was unprocessed due to metadata failure or was missing");
            }
            this.getWriter().writeValidationReport(this.getErrors(), this.getWarnings());
            if (this.isLocal()) {
                this.getWriter().writeFile(this.getOutputFileName());
            } else {
                this.getWriter().writeFile();
            }
        }
        catch (IOException e) {
            log.fatal((Object)e);
        }
    }
}

