/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.describe;

import com.apple.jingle.leghorn.audio.describe.AudioDescriptionWriterUtil;
import com.apple.jingle.leghorn.audio.helpers.DescriptionWriter;
import com.apple.jingle.leghorn.audio.wav.beans.DataChunk;
import com.apple.jingle.leghorn.audio.wav.beans.FactChunk;
import com.apple.jingle.leghorn.audio.wav.beans.FormatChunk;
import com.apple.jingle.leghorn.audio.wav.beans.IntegerWithUnits;
import com.apple.jingle.leghorn.audio.wav.beans.Overview;
import com.apple.jingle.leghorn.audio.wav.beans.RiffChunk;
import com.apple.jingle.leghorn.audio.wav.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.audio.wav.beans.ValidationReport;
import java.io.IOException;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public class WavDescriptionWriter
extends DescriptionWriter {
    private StreamDescriptionDocument document = StreamDescriptionDocument.Factory.newInstance();
    private StreamDescriptionDocument.StreamDescription wavStream = this.document.addNewStreamDescription();
    private RiffChunk riff;
    private FormatChunk format;
    private FactChunk fact;
    private DataChunk data;
    private ValidationReport report;
    private Overview overview;
    private boolean _hasChannelAllocations = false;
    private boolean _hasADMXml = false;
    private Long dataRate;
    private Long dataSize;

    protected Overview getOverview() {
        if (this.overview == null) {
            this.overview = this.wavStream.addNewOverview();
        }
        return this.overview;
    }

    public WavDescriptionWriter(String uti, String assetType) {
    }

    public void writeFileSize(long fileSize) {
        this.getOverview().setFileSize(fileSize);
    }

    public void writeRiffChunk(String chunkID, int chunkSize, String waveID) {
        this.riff = this.wavStream.addNewRiffChunk();
        this.riff.setChunkId(chunkID);
        IntegerWithUnits size = AudioDescriptionWriterUtil.newIntegerWithBytes(chunkSize);
        this.riff.setChunkSize(size);
        this.riff.setWaveId(waveID);
    }

    public void writeFormatHeader(String formatHeader, int chunkSize, int formatCode, String formatType) {
        this.format = this.wavStream.addNewFormatChunk();
        this.format.setChunkId(formatHeader);
        this.format.setChunkSize(AudioDescriptionWriterUtil.newIntegerWithBytes(chunkSize));
        this.format.setFormatCode("0x" + Integer.toHexString(formatCode));
        this.format.setFormatType(formatType);
    }

    public void writeCommonData(int channels, int sampleRate, int dataRate, int blockSize, int bitDepth) {
        this.format.setChannels(channels);
        this.format.setSampleRate(AudioDescriptionWriterUtil.newIntegerWithUnits(sampleRate, AudioDescriptionWriterUtil.Units.HERTZ));
        this.format.setDataRate(AudioDescriptionWriterUtil.newIntegerWithUnits(dataRate, AudioDescriptionWriterUtil.Units.BYTESPERSECOND));
        this.format.setBlockSize(AudioDescriptionWriterUtil.newIntegerWithBytes(blockSize));
        this.format.setBitDepth(bitDepth);
        this.dataRate = dataRate;
        this.updateDuration();
    }

    public void writeExtensible(int valid, int mask, String subFormat) {
        this.format.setValidBitsPerSample(valid);
        this.format.setSpeakerPositionMask(mask);
        this.format.setSubFormat(subFormat);
    }

    public void writeFact(String chunkID, int chunkSize, int totalSamples) {
        this.fact = this.wavStream.addNewFactChunk();
        this.fact.setChunkId(chunkID);
        this.fact.setChunkSize(AudioDescriptionWriterUtil.newIntegerWithBytes(chunkSize));
        this.fact.setSamplesPerChannel(totalSamples);
    }

    public void writeData(String chunkID, int chunkSize) {
        this.data = this.wavStream.addNewDataChunk();
        this.data.setChunkId(chunkID);
        this.data.setChunkSize(AudioDescriptionWriterUtil.newIntegerWithBytes(chunkSize));
        this.dataSize = chunkSize;
        this.updateDuration();
    }

    public void writeValidationReport(List<String> errors, List<String> warnings) {
        int i;
        this.report = this.wavStream.addNewValidationReport();
        this.report.setWarnings(warnings.size());
        this.report.setErrors(errors.size());
        for (i = 0; i < warnings.size(); ++i) {
            this.report.addWarning(warnings.get(i));
        }
        for (i = 0; i < errors.size(); ++i) {
            this.report.addError(errors.get(i));
        }
    }

    public void writeFile(String fileName) throws IOException {
        this.writeFile(fileName, (XmlObject)this.document);
    }

    public void writeFile() {
        this.writeFile((XmlObject)this.document);
    }

    public boolean hasChannelAllocations() {
        return this._hasChannelAllocations;
    }

    public void setChannelAllocations(boolean b) {
        this._hasChannelAllocations = b;
    }

    public boolean hasADMXml() {
        return this._hasADMXml;
    }

    public void setADMXml(boolean b) {
        this._hasADMXml = b;
    }

    private void updateDuration() {
        if (this.dataRate != null && this.dataSize != null) {
            float dataRate = this.dataRate.longValue();
            float dataSize = this.dataSize.longValue();
            float duration = dataSize / dataRate;
            this.getOverview().setDuration(AudioDescriptionWriterUtil.newFloatWithUnits(duration, AudioDescriptionWriterUtil.Units.SECONDS));
        }
    }
}

