/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.describe;

import com.apple.jingle.leghorn.audio.flac.beans.ApplicationBlock;
import com.apple.jingle.leghorn.audio.flac.beans.AudioFrame;
import com.apple.jingle.leghorn.audio.flac.beans.BlockSize;
import com.apple.jingle.leghorn.audio.flac.beans.CueSheet;
import com.apple.jingle.leghorn.audio.flac.beans.FloatWithUnits;
import com.apple.jingle.leghorn.audio.flac.beans.FrameSize;
import com.apple.jingle.leghorn.audio.flac.beans.Metadata;
import com.apple.jingle.leghorn.audio.flac.beans.Overview;
import com.apple.jingle.leghorn.audio.flac.beans.Padding;
import com.apple.jingle.leghorn.audio.flac.beans.Picture;
import com.apple.jingle.leghorn.audio.flac.beans.SampleRate;
import com.apple.jingle.leghorn.audio.flac.beans.SeekTable;
import com.apple.jingle.leghorn.audio.flac.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.audio.flac.beans.StreamInfoBlock;
import com.apple.jingle.leghorn.audio.flac.beans.ValidationReport;
import com.apple.jingle.leghorn.audio.flac.beans.VorbisComment;
import com.apple.jingle.leghorn.audio.flac.beans.VorbisCommentBlock;
import com.apple.jingle.leghorn.audio.helpers.DescriptionWriter;
import java.io.IOException;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public class FlacDescriptionWriter
extends DescriptionWriter {
    private StreamDescriptionDocument description = StreamDescriptionDocument.Factory.newInstance();
    private StreamDescriptionDocument.StreamDescription stream = this.description.addNewStreamDescription();
    private Metadata block;
    private CueSheet sheet;
    private Overview overview;

    protected Overview getOverview() {
        if (this.overview == null) {
            this.overview = this.stream.addNewOverview();
        }
        return this.overview;
    }

    public FlacDescriptionWriter(String uti, String assetType) {
        this.stream.setUti(uti);
        this.stream.setAssetType(assetType);
    }

    public void writeFileSize(long fileSize) {
        this.getOverview().setFileSize(fileSize);
    }

    public void writeFileHeader(String ID) {
        this.stream.setHeader(ID);
    }

    public void writeStreamInfo(int maxBlockSize, int minBlockSize, int maxFrameSize, int minFrameSize, int sampleRate, String blockUnits, String frameUnits, String sampleUnits, int channels, int bps, long totalSamples, String MD5) {
        this.block = this.stream.addNewMetadata();
        StreamInfoBlock strInfo = this.block.addNewStreamInfo();
        BlockSize min = strInfo.addNewMinBlockSize();
        min.setIntValue(minBlockSize);
        min.setUnits(blockUnits);
        BlockSize max = strInfo.addNewMaxBlockSize();
        max.setIntValue(maxBlockSize);
        max.setUnits(blockUnits);
        FrameSize minF = strInfo.addNewMinFrameSize();
        minF.setIntValue(minFrameSize);
        minF.setUnits(frameUnits);
        FrameSize maxF = strInfo.addNewMaxFrameSize();
        maxF.setIntValue(maxFrameSize);
        maxF.setUnits(frameUnits);
        SampleRate rate = strInfo.addNewSampleRate();
        rate.setIntValue(sampleRate);
        rate.setUnits(sampleUnits);
        strInfo.setChannels(channels);
        strInfo.setBitDepth(bps);
        strInfo.setTotalSamples(totalSamples);
        strInfo.setMd5(MD5);
        float duration = (float)totalSamples / (float)sampleRate;
        this.getOverview().setDuration(this.newFloatWithUnits(duration, "seconds"));
    }

    public void writeApplicationBlock(int applicationID) {
        ApplicationBlock app = this.block.addNewApplication();
        app.setApplicationID(applicationID);
    }

    public void writePadding(int blockLength) {
        Padding padding = this.block.addNewPadding();
        padding.setLengthInBits(blockLength);
    }

    public void writeSeekTable(int points, long[][] seekPoints) {
        SeekTable table = this.block.addNewSeektable();
        table.setPoints(points);
    }

    public void writeVorbisComments(String vendorName, int numberOfComments, String[] vorbisComments) {
        VorbisCommentBlock vorbis = this.block.addNewVorbisComments();
        vorbis.setVendorName(vendorName);
        vorbis.setComments(numberOfComments);
        for (int i = 0; i < numberOfComments; ++i) {
            VorbisComment comment = vorbis.addNewComment();
            comment.setComment(vorbisComments[i]);
        }
    }

    public void writeCueSheet(String catalogNumber, long leadInSamples, int cdFlag, int numberOfTracks, int reserveLength) {
        this.sheet = this.block.addNewCuesheet();
        this.sheet.setCatalogNumber(catalogNumber);
        this.sheet.setTracks(numberOfTracks);
    }

    public void writePicture(int mimeLength, String mimeType, int descrLength, String description, int pictureWidth, int pictureHeight, int colorDepth, int numberOfColors, int picSize) {
        Picture picture = this.block.addNewPicture();
        picture.setMimeType(mimeType);
        picture.setUtfDescription(description);
        picture.setWidthInPixels(pictureWidth);
        picture.setHeightInPixels(pictureHeight);
        picture.setColorDepth(colorDepth);
        picture.setNumberOfColors(numberOfColors);
    }

    public void writeFrames(int numberOfFrames, String blockingStrategy, int blockSize, String units) {
        AudioFrame frames = this.stream.addNewAudioframes();
        frames.setBlockingStrategy(blockingStrategy);
        BlockSize bs = frames.addNewLastBlockSize();
        bs.setIntValue(blockSize);
        bs.setUnits(units);
        frames.setFrames(numberOfFrames);
    }

    public void writeValidationReport(List<String> errors, List<String> warnings) {
        int i;
        ValidationReport report = this.stream.addNewValidationreport();
        report.setWarnings(warnings.size());
        report.setErrors(errors.size());
        for (i = 0; i < warnings.size(); ++i) {
            report.addWarning(warnings.get(i));
        }
        for (i = 0; i < errors.size(); ++i) {
            report.addError(errors.get(i));
        }
    }

    public String makeDocument() {
        return this.description.toString();
    }

    public void writeFile(String fileName) throws IOException {
        this.writeFile(fileName, (XmlObject)this.description);
    }

    public void writeFile() {
        this.writeFile((XmlObject)this.description);
    }

    private FloatWithUnits newFloatWithUnits(float value, String units) {
        FloatWithUnits result = FloatWithUnits.Factory.newInstance();
        result.setFloatValue(value);
        result.setUnits(units);
        return result;
    }
}

