/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.describe;

import com.apple.jingle.leghorn.audio.ADM.ADMData;
import com.apple.jingle.leghorn.audio.ADM.ADMUtil;
import com.apple.jingle.leghorn.audio.ADM.AudioObject;
import com.apple.jingle.leghorn.audio.ADM.ChannelAllocationTable;
import com.apple.jingle.leghorn.audio.ADM.TimeInterval;
import com.apple.jingle.leghorn.audio.BWF.BWFFile;
import com.apple.jingle.leghorn.audio.describe.AudioDescriptionWriterUtil;
import com.apple.jingle.leghorn.audio.wav.beans.ADMDataDs;
import com.apple.jingle.leghorn.audio.wav.beans.AudioObjectDs;
import com.apple.jingle.leghorn.audio.wav.beans.AudioObjectsDs;
import com.apple.jingle.leghorn.audio.wav.beans.ChannelAllocation;
import com.apple.jingle.leghorn.audio.wav.beans.ChnaItem;
import com.apple.jingle.leghorn.audio.wav.beans.DataChunk;
import com.apple.jingle.leghorn.audio.wav.beans.FormatChunk;
import com.apple.jingle.leghorn.audio.wav.beans.IntegerWithUnits;
import com.apple.jingle.leghorn.audio.wav.beans.Overview;
import com.apple.jingle.leghorn.audio.wav.beans.RiffChunk;
import com.apple.jingle.leghorn.audio.wav.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.audio.wav.beans.ValidationReport;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BWFDescriptionWriter {
    public static void createADMDescription(BWFFile file, StreamDescriptionDocument.StreamDescription wavStream) {
        ADMData admData;
        List<TimeInterval> timeIntervals;
        ADMDataDs admDataDesc = wavStream.addNewADMData();
        List<ChannelAllocationTable.ChannelAllocationEntry> fileChna = file.channelAllocationList();
        admDataDesc.setChannelAllocationCount(fileChna.size());
        if (fileChna.size() > 0) {
            ChannelAllocation channelAllocations = admDataDesc.addNewChannelAllocation();
            for (ChannelAllocationTable.ChannelAllocationEntry e : fileChna) {
                ChnaItem aChnaItem = channelAllocations.addNewChnaItem();
                aChnaItem.setTrackNum(e.trackID);
                aChnaItem.setTrackUID(e.UID);
                aChnaItem.setTrackFormat(e.TrackRef);
                aChnaItem.setPackFormat(e.PackRef);
            }
        }
        if ((timeIntervals = (admData = file.ADMData()).getFlatenDurationIntervals()).size() == 0) {
            // empty if block
        }
        if (timeIntervals.size() == 1) {
            TimeInterval ti = timeIntervals.get(0);
            admDataDesc.setStartTimeTotal(ADMUtil.nanoSecondsToString(ti._start));
            admDataDesc.setEndTimeTotal(ADMUtil.nanoSecondsToString(ti.end()));
            admDataDesc.setDurationTotal(ADMUtil.nanoSecondsToString(ti._duration));
        }
        admDataDesc.setAudioObjectCount(admData.getAudioObjectCount());
        if (admData.getAudioObjectCount() > 0) {
            AudioObjectsDs audioObjectDs = admDataDesc.addNewAudioObjects();
            for (AudioObject ao : admData.getAllAudioObjects()) {
                AudioObjectDs aods = audioObjectDs.addNewAudioObject();
                aods.setName(ao.name());
                aods.setId(ao.id());
                aods.setStartTime(ADMUtil.nanoSecondsToString(ao.start()));
                aods.setDuration(ADMUtil.nanoSecondsToString(ao.duration()));
            }
        }
    }

    public static ContainerDescription<Node> createDescription(BWFFile file, ContainerType type) {
        StreamDescriptionDocument document = StreamDescriptionDocument.Factory.newInstance();
        StreamDescriptionDocument.StreamDescription wavStream = document.addNewStreamDescription();
        Overview overview = wavStream.addNewOverview();
        overview.setFileSize(file.fileSize());
        overview.setDuration(AudioDescriptionWriterUtil.newFloatWithUnits((float)file.durationSeconds(), AudioDescriptionWriterUtil.Units.SECONDS));
        RiffChunk riff = wavStream.addNewRiffChunk();
        riff.setChunkId(file.riffMagic());
        IntegerWithUnits size = AudioDescriptionWriterUtil.newIntegerWithBytes((int)file.riffSize());
        riff.setChunkSize(size);
        riff.setWaveId(file.riffFormat());
        FormatChunk format = wavStream.addNewFormatChunk();
        format.setChunkId("fmt");
        format.setChunkSize(AudioDescriptionWriterUtil.newIntegerWithBytes((int)file.fmtSize()));
        format.setFormatCode("0x" + Integer.toHexString(file.formatType()));
        format.setFormatType(file.formatTypeString());
        format.setChannels(file.channelCount());
        format.setSampleRate(AudioDescriptionWriterUtil.newIntegerWithUnits((int)file.sampleRate(), AudioDescriptionWriterUtil.Units.HERTZ));
        format.setDataRate(AudioDescriptionWriterUtil.newIntegerWithUnits((int)file.bytesPerSecond(), AudioDescriptionWriterUtil.Units.BYTESPERSECOND));
        format.setBlockSize(AudioDescriptionWriterUtil.newIntegerWithBytes(file.byteAlignment()));
        format.setBitDepth(file.bitsPerSample());
        DataChunk data = wavStream.addNewDataChunk();
        data.setChunkId("data");
        data.setChunkSize(AudioDescriptionWriterUtil.newIntegerWithBytes((int)file.dataSize()));
        ValidationReport report = wavStream.addNewValidationReport();
        report.setWarnings(0);
        report.setErrors(0);
        if (file.hasADMData()) {
            BWFDescriptionWriter.createADMDescription(file, wavStream);
        }
        Document flacDescription = (Document)document.newDomNode();
        DocumentBuilder descriptionBuilder = null;
        try {
            descriptionBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Internal error generating description document");
        }
        Document descriptor = descriptionBuilder.newDocument();
        Element describerRoot = (Element)descriptor.importNode(flacDescription.getDocumentElement(), true);
        descriptor.appendChild(describerRoot);
        return new SingleStreamContainerDescription(descriptor, "sound", null, type);
    }
}

