/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.caf;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.RIFF.ChannelChunk;
import com.apple.jingle.leghorn.audio.RIFF.DataChunk;
import com.apple.jingle.leghorn.audio.RIFF.DescriptionChunk;
import com.apple.jingle.leghorn.audio.RIFF.DescriptionListChunk;
import com.apple.jingle.leghorn.audio.RIFF.FreeChunk;
import com.apple.jingle.leghorn.audio.RIFF.InfoChunk;
import com.apple.jingle.leghorn.audio.RIFF.KukiChunk;
import com.apple.jingle.leghorn.audio.RIFF.LoudChunk;
import com.apple.jingle.leghorn.audio.RIFF.PacketTableChunk;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.audio.RIFF.UnknownChunk;
import com.apple.jingle.leghorn.audio.caf.CAAudioChannelLabel;
import com.apple.jingle.leghorn.audio.caf.CAChannelBitmap;
import com.apple.jingle.leghorn.audio.caf.CAChannelDescriptor;
import com.apple.jingle.leghorn.audio.caf.CAChannelLayoutTag;
import com.apple.jingle.leghorn.audio.caf.CAFFile;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class CAFParser {
    protected static final Map<String, Class<? extends RiffChunkBase>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends RiffChunkBase>>();
    protected static final Logger loger = Logger.getLogger(CAFParser.class);
    private static final String CAFF_MAGIC = "caff";

    public static void main(String[] args) throws Exception {
        CAFParser parser = new CAFParser();
        String fileArgument = args[0];
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(fileArgument);
        URI uri = ContainerContainerDescriberRunner.uriForString(fileArgument);
        CAFFile file = parser.parseFile((LeghornValidationContext)ctx, uri);
        if (file.hasSoundcheckData()) {
            System.out.println("SoundCheckData=\n" + file.soundcheckData());
        } else {
            System.out.println("No soundcheck data");
        }
    }

    public CAFFile parseFile(@Nonnull LeghornValidationContext ctx, SeekableDataInput movieFile) throws IOException {
        return this.parseInput(ctx, movieFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CAFFile parseFile(@Nonnull LeghornValidationContext ctx, URI movieFile) throws IOException {
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)movieFile);){
            CAFFile cAFFile = this.parseInput(ctx, sdi);
            return cAFFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CAFFile parseFile(@Nonnull LeghornValidationContext ctx, File movieFile) throws IOException {
        try (FileSeekableDataInput sdi = new FileSeekableDataInput(movieFile.getAbsolutePath());){
            CAFFile cAFFile = this.parseInput(ctx, (SeekableDataInput)sdi);
            return cAFFile;
        }
    }

    public CAFFile parseInput(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        return this.parseInputInternal(ctx, sdi);
    }

    private CAFFile parseInputInternal(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        LoudChunk loudChunk;
        RiffChunkBase maybeSoundcheckData;
        RiffChunkBase maybeDescList;
        RiffChunkBase chunk;
        CAFFile caffile = new CAFFile();
        if (sdi.length() < 1L) {
            ctx.addCheckAlert(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary);
            return caffile;
        }
        String fileType = BitstreamReader.readFourCC((DataInput)sdi);
        if (!fileType.equals(CAFF_MAGIC)) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_MAGIC_MISSING, MediaUtil.dictionary);
            return caffile;
        }
        caffile.setVersion(BitstreamReader.readU16(sdi));
        caffile.setFlags(BitstreamReader.readU16(sdi));
        ArrayList<RiffChunkBase> chuckList = new ArrayList<RiffChunkBase>();
        while (sdi.getFilePointer() < sdi.length() && (chunk = this.readChunk(ctx, sdi)) != null) {
            long curPos = sdi.getFilePointer();
            long curSize = chunk.size();
            chunk.parse(ctx, sdi);
            if (curSize != -1L && sdi.getFilePointer() < curPos + curSize) {
                long paddedBytes = curPos + curSize - sdi.getFilePointer();
                loger.info((Object)("Chunk " + chunk.name() + " has " + paddedBytes + " bytes of padding. Skiping " + paddedBytes + " bytes."));
                sdi.seek(curPos + curSize);
            }
            chuckList.add(chunk);
        }
        if (chuckList.size() == 0) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_CHUNKS_MISSING, MediaUtil.dictionary);
            return caffile;
        }
        if (!(chuckList.get(0) instanceof DescriptionChunk)) {
            ctx.addCheckAlert(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary);
            return caffile;
        }
        DescriptionChunk desc = (DescriptionChunk)chuckList.get(0);
        caffile.setDescription(desc.description());
        this.computeChannelLayout(chuckList, caffile);
        RiffChunkBase maybeData = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "data".equals(riffChunkBase.name());
            }
        }, null);
        if (!(maybeData instanceof DataChunk)) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_DATA_MISSING, MediaUtil.dictionary);
            return caffile;
        }
        DataChunk dataChunk = (DataChunk)maybeData;
        caffile.setDataSize(dataChunk.size());
        RiffChunkBase maybePacketTable = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "pakt".equals(riffChunkBase.name());
            }
        }, null);
        if (maybePacketTable instanceof PacketTableChunk) {
            PacketTableChunk packetTable = (PacketTableChunk)maybePacketTable;
            caffile.setNumberPackets(packetTable.numberPackets());
            caffile.setNumberValidFrames(packetTable.numberValidFrames());
            caffile.setPrimingFrames(packetTable.primingFrames());
            caffile.setRemainderFrames(packetTable.remainderFrames());
        } else if (caffile.isCompressedFormat()) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_PACKET_TABLE_MISSING, MediaUtil.dictionary);
        }
        RiffChunkBase maybeInfo = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "info".equals(riffChunkBase.name());
            }
        }, null);
        if (maybeInfo instanceof InfoChunk) {
            InfoChunk infoChunk = (InfoChunk)maybeInfo;
            caffile.setInfo(infoChunk.entries());
        }
        if ((maybeDescList = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "ldsc".equals(riffChunkBase.name());
            }
        }, null)) instanceof DescriptionListChunk) {
            DescriptionListChunk descList = (DescriptionListChunk)maybeDescList;
            caffile.setDescriptionList(descList.entries());
        }
        if ((maybeSoundcheckData = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "loud".equals(riffChunkBase.name());
            }
        }, null)) instanceof LoudChunk && (loudChunk = (LoudChunk)maybeSoundcheckData).hasData()) {
            caffile.setSoundcheckData(loudChunk.data());
        }
        return caffile;
    }

    private void computeChannelLayout(List<RiffChunkBase> chuckList, CAFFile caffile) {
        RiffChunkBase maybeChan = (RiffChunkBase)Iterables.find(chuckList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "chan".equals(riffChunkBase.name());
            }
        }, null);
        if (!(maybeChan instanceof ChannelChunk)) {
            return;
        }
        ChannelChunk channelChunk = (ChannelChunk)maybeChan;
        String channelLayout = "";
        if (channelChunk.channelLayoutTag() == CAChannelLayoutTag.UseChannelDescriptions.getValue()) {
            channelLayout = "channel descriptor:";
            for (CAChannelDescriptor desc : channelChunk.channelDescriptions()) {
                channelLayout = channelLayout + " " + CAAudioChannelLabel.fromLong(desc._channelLabel).cname();
            }
        } else if (channelChunk.channelLayoutTag() == CAChannelLayoutTag.UseChannelBitmap.getValue()) {
            channelLayout = "channel bitmap:";
            long channelBitmap = channelChunk.channelBitmap();
            if (channelBitmap != 0L) {
                if ((channelBitmap & CAChannelBitmap.Left.value()) != 0L) {
                    channelLayout = channelLayout + " L";
                } else if ((channelBitmap & CAChannelBitmap.Right.value()) != 0L) {
                    channelLayout = channelLayout + " R";
                } else if ((channelBitmap & CAChannelBitmap.Center.value()) != 0L) {
                    channelLayout = channelLayout + " C";
                } else if ((channelBitmap & CAChannelBitmap.LFEScreen.value()) != 0L) {
                    channelLayout = channelLayout + " LFE";
                } else if ((channelBitmap & CAChannelBitmap.LeftSurround.value()) != 0L) {
                    channelLayout = channelLayout + " Ls";
                } else if ((channelBitmap & CAChannelBitmap.RightSurround.value()) != 0L) {
                    channelLayout = channelLayout + " Rs";
                } else if ((channelBitmap & CAChannelBitmap.LeftCenter.value()) != 0L) {
                    channelLayout = channelLayout + " Lc";
                } else if ((channelBitmap & CAChannelBitmap.RightCenter.value()) != 0L) {
                    channelLayout = channelLayout + " Rc";
                } else if ((channelBitmap & CAChannelBitmap.CenterSurround.value()) != 0L) {
                    channelLayout = channelLayout + " Cs";
                } else if ((channelBitmap & CAChannelBitmap.LeftSurroundDirect.value()) != 0L) {
                    channelLayout = channelLayout + " Lsd";
                } else if ((channelBitmap & CAChannelBitmap.RightSurroundDirect.value()) != 0L) {
                    channelLayout = channelLayout + "Rsd";
                } else if ((channelBitmap & CAChannelBitmap.TopCenterSurround.value()) != 0L) {
                    channelLayout = channelLayout + " Tcs";
                } else if ((channelBitmap & CAChannelBitmap.VerticalHeightLeft.value()) != 0L) {
                    channelLayout = channelLayout + " Vhl";
                } else if ((channelBitmap & CAChannelBitmap.VerticalHeightCenter.value()) != 0L) {
                    channelLayout = channelLayout + " Vhc";
                } else if ((channelBitmap & CAChannelBitmap.VerticalHeightRight.value()) != 0L) {
                    channelLayout = channelLayout + " Vhr";
                } else if ((channelBitmap & CAChannelBitmap.TopBackLeft.value()) != 0L) {
                    channelLayout = channelLayout + " Tl";
                } else if ((channelBitmap & CAChannelBitmap.TopBackCenter.value()) != 0L) {
                    channelLayout = channelLayout + " Tc";
                } else if ((channelBitmap & CAChannelBitmap.TopBackRight.value()) != 0L) {
                    channelLayout = channelLayout + " Tr";
                }
            } else {
                channelLayout = channelLayout + " invalid (set to zero)";
            }
        } else {
            channelLayout = CAChannelLayoutTag.nameFromLong(channelChunk.channelLayoutTag());
        }
        caffile.setChannelLayout(channelLayout);
    }

    private RiffChunkBase readChunk(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        long curFilePos = sdi.getFilePointer();
        long remain = sdi.length() - curFilePos;
        if (remain < 12L) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_CHUNK_TOOSMALL_INVALID, MediaUtil.dictionary.add("available", Long.toString(remain)).add("offset", Long.toString(curFilePos)));
            return null;
        }
        String chkName = BitstreamReader.readFourCC((DataInput)sdi);
        long size = BitstreamReader.read64((DataInput)sdi);
        if (size == -1L && "data".equals(chkName)) {
            size = sdi.length() - sdi.getFilePointer();
        }
        if (size < 0L) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_CHUNK_SIZE_INVALID, MediaUtil.dictionary.add("name", chkName).add("size", Long.toString(size)));
            return null;
        }
        if (remain < size + 12L) {
            ctx.addCheckAlert(MediaValidationCode.CAFF_CHUNK_TOOLARGE_INVALID, MediaUtil.dictionary.add("name", chkName).add("needed", Long.toString(size + 12L)).add("available", Long.toString(remain)));
            return null;
        }
        RiffChunkBase chunk = null;
        if (TYPE_CLASS_MAP.containsKey(chkName)) {
            try {
                Class<? extends RiffChunkBase> klass = TYPE_CLASS_MAP.get(chkName);
                Constructor<? extends RiffChunkBase> constructor = klass.getConstructor(String.class, Long.TYPE, Long.TYPE);
                chunk = constructor.newInstance(chkName, curFilePos, size);
            }
            catch (Exception e) {
                loger.debug((Object)e);
            }
        } else {
            loger.debug((Object)("Not in TYPE_CLASS_MAP: " + chkName));
            chunk = new UnknownChunk(chkName, curFilePos, size);
        }
        return chunk;
    }

    static {
        TYPE_CLASS_MAP.put("desc", DescriptionChunk.class);
        TYPE_CLASS_MAP.put("chan", ChannelChunk.class);
        TYPE_CLASS_MAP.put("free", FreeChunk.class);
        TYPE_CLASS_MAP.put("data", DataChunk.class);
        TYPE_CLASS_MAP.put("kuki", KukiChunk.class);
        TYPE_CLASS_MAP.put("pakt", PacketTableChunk.class);
        TYPE_CLASS_MAP.put("info", InfoChunk.class);
        TYPE_CLASS_MAP.put("ldsc", DescriptionListChunk.class);
        TYPE_CLASS_MAP.put("loud", LoudChunk.class);
    }
}

