/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.caf;

import com.apple.jingle.leghorn.audio.RIFF.DescriptionCommonData;
import com.apple.jingle.leghorn.audio.RIFF.DescriptionListData;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAFFile {
    private int _version = 0;
    private int _flags = 0;
    private DescriptionCommonData _description = DescriptionCommonData.INVALID;
    private long _dataSize = 0L;
    private String _channelLayout = "";
    private long _numberPackets = -1L;
    private long _numberValidFrames = -1L;
    private int _primingFrames = -1;
    private int _remainderFrames = -1;
    private Map<String, String> _info = new HashMap<String, String>();
    private List<DescriptionListData> _descriptionList = new ArrayList<DescriptionListData>();
    private String _soundCheckData = "";

    public int version() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int flags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public boolean hasValidDescriptionChunk() {
        return this._description != DescriptionCommonData.INVALID;
    }

    public double sampleRate() {
        return this._description._sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        this._description._sampleRate = sampleRate;
    }

    public String formatID() {
        return this._description._formatID;
    }

    public void setFormatID(String formatID) {
        this._description._formatID = formatID;
    }

    public long formatFlag() {
        return this._description._flags;
    }

    public void setFormatFlag(long formatFlag) {
        this._description._flags = formatFlag;
    }

    public long bytesPerPacket() {
        return this._description._bytesPerPacket;
    }

    public void setBytesPerPacket(long bytesPerPacket) {
        this._description._bytesPerPacket = bytesPerPacket;
    }

    public long framesPerPacket() {
        return this._description._framesPerPacket;
    }

    public void setFramesPerPacket(long framesPerPacket) {
        this._description._framesPerPacket = framesPerPacket;
    }

    public long channelsPerFrame() {
        return this._description._channelsPerFrame;
    }

    public void setChannelsPerFrame(long channelsPerFrame) {
        this._description._channelsPerFrame = channelsPerFrame;
    }

    public long bitsPerChannel() {
        return this._description._bitsPerChannel;
    }

    public void setBitsPerChannel(long _bitsPerChannel) {
        this._description._bitsPerChannel = _bitsPerChannel;
    }

    public void setDescription(DescriptionCommonData desc) {
        this._description = desc;
    }

    public void setDescriptionList(List<DescriptionListData> ldesc) {
        this._descriptionList = ldesc;
    }

    public List<DescriptionListData> descriptionList() {
        return new ArrayList<DescriptionListData>(this._descriptionList);
    }

    public int descriptionListSize() {
        return this._descriptionList.size();
    }

    public long dataSize() {
        return this._dataSize;
    }

    public void setDataSize(long dataSize) {
        this._dataSize = dataSize;
    }

    public double dataRate() {
        return (double)this._dataSize / this.durationSeconds() / 128.0;
    }

    public boolean isCompressedFormat() {
        return 0L == this._description._bitsPerChannel;
    }

    public boolean isVariableBitRate() {
        return 0L == this._description._bytesPerPacket;
    }

    public boolean isVariableFramePerPacket() {
        return 0L == this._description._framesPerPacket;
    }

    public double durationSeconds() {
        double[] dur = this.durationRational();
        return dur[0] / dur[1];
    }

    public double[] durationRational() {
        if (this.isCompressedFormat()) {
            if (!this.isVariableFramePerPacket()) {
                return new double[]{this._description._framesPerPacket * this._numberPackets - (long)this._primingFrames, this._description._sampleRate};
            }
            return new double[]{0.0, 1.0};
        }
        return new double[]{(double)this._dataSize / (double)(this._description._bytesPerPacket * this._description._framesPerPacket), this._description._sampleRate};
    }

    public String getSampleFormat() {
        String ret = "";
        if (this._description._bitsPerChannel != 0L) {
            ret = ret + String.valueOf(this._description._bitsPerChannel) + "-bit ";
        }
        if ("lpcm".equals(this._description._formatID)) {
            ret = (this._description._flags >> 1 & 1L) == 1L ? ret + "little-endian " : ret + "big-endian ";
            ret = (this._description._flags & 1L) == 1L ? ret + "float " : ret + "integer ";
        }
        return ret;
    }

    public String channelLayout() {
        if (Strings.isNullOrEmpty((String)this._channelLayout)) {
            if (this._description._channelsPerFrame == 2L) {
                return "Stereo (L R)";
            }
            return "Unknown";
        }
        return this._channelLayout;
    }

    public void setChannelLayout(String _channelLayout) {
        this._channelLayout = _channelLayout;
    }

    public long numberPackets() {
        return this._numberPackets;
    }

    public void setNumberPackets(long n) {
        this._numberPackets = n;
    }

    public long numberValidFrames() {
        return this._numberValidFrames;
    }

    public void setNumberValidFrames(long n) {
        this._numberValidFrames = n;
    }

    public int primingFrames() {
        return this._primingFrames;
    }

    public void setPrimingFrames(int n) {
        this._primingFrames = n;
    }

    public int remainderFrames() {
        return this._remainderFrames;
    }

    public void setRemainderFrames(int n) {
        this._remainderFrames = n;
    }

    public Map<String, String> info() {
        return new HashMap<String, String>(this._info);
    }

    public void setInfo(Map<String, String> v) {
        this._info = new HashMap<String, String>(v);
    }

    public int infoEntryCount() {
        return this._info.size();
    }

    public void setSoundcheckData(String data) {
        this._soundCheckData = data;
    }

    public boolean hasSoundcheckData() {
        return !Strings.isNullOrEmpty((String)this._soundCheckData);
    }

    public String soundcheckData() {
        return this._soundCheckData;
    }
}

