/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMParser;
import com.apple.jingle.leghorn.audio.BWF.BWFFile;
import com.apple.jingle.leghorn.audio.BWF.BWFParser;
import com.apple.jingle.leghorn.audio.BWF.BWFValidationContext;
import com.apple.jingle.leghorn.audio.describe.BWFDescriptionWriter;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.provide.BitReader;
import com.apple.jingle.leghorn.audio.wav.WavValidationService;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class WavDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    private static final Logger log = Logger.getLogger(WavDescriberVerifier.class);
    WavValidationService service;
    private String schemaName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        boolean verified;
        try {
            log.trace((Object)"Calling describer.");
            this.doTheDescribing(sdi, listener, false, type.getUTITypeName(), type.getName());
            verified = true;
        }
        catch (AudioDescriptionException e) {
            if (e.getError() == null) {
                listener.error(new ValidationError(e.getMessage(), MediaValidationCode.AUD_APPEARS_CORRUPT));
            } else {
                listener.error(e.getError());
            }
            verified = false;
        }
        return verified;
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        String fileType = BitstreamReader.readFourCC((DataInput)sdi);
        sdi.seek(0L);
        if ("RF64".equals(fileType)) {
            return this.BWFDescribe(sdi, type);
        }
        this.doTheDescribing(sdi, null, false, type.getUTITypeName(), type.getName());
        if (this.service.getWriter().hasADMXml() && this.service.getWriter().hasChannelAllocations()) {
            sdi.seek(0L);
            return this.BWFDescribe(sdi, type);
        }
        return new SingleStreamContainerDescription(this.service.getWriter().getDescriptor(), "sound", null, type);
    }

    private ContainerDescription<Node> BWFDescribe(SeekableDataInput sdi, ContainerType type) throws IOException {
        BWFParser parser = new BWFParser();
        BWFValidationContext ctx = new BWFValidationContext(sdi.getFileName());
        BWFFile bwffile = parser.parseFile((LeghornValidationContext)ctx, sdi);
        if (bwffile.hasXmlADM()) {
            ADMParser admParser = new ADMParser();
            bwffile.setADMData(admParser.parse((LeghornValidationContext)ctx, bwffile.xmlADM()));
        }
        return BWFDescriptionWriter.createDescription(bwffile, type);
    }

    public void describe(SeekableDataInput sdi) {
        try {
            this.doTheDescribing(sdi, null, true, "com.microsoft.waveform-audio", "Wav Audio File");
        }
        catch (IOException e) {
        }
        catch (AudioDescriptionException e) {
            log.error((Object)"Audio container error.", (Throwable)e);
        }
    }

    private void doTheDescribing(SeekableDataInput sdi, ValidationListener listener, boolean locality, String uti, String type) throws AudioDescriptionException, IOException {
        try {
            this.service = new WavValidationService(sdi, listener, locality, uti, type);
            this.service.validate();
        }
        catch (BitReader.HitEndOfFileException ignored) {
            // empty catch block
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn WAV Describer";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

