/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.RIFF;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import javax.annotation.Nonnull;

public class PacketTableChunk
extends RiffChunkBase {
    private long _numberPackets = 0L;
    private long _numberValidFrames = 0L;
    private int _primingFrames = 0;
    private int _remainderFrames = 0;

    public PacketTableChunk(String name, long offset, long size) {
        super(name, offset, size);
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        long beginDataPos = sdi.getFilePointer();
        this._numberPackets = BitstreamReader.read64((DataInput)sdi);
        this._numberValidFrames = BitstreamReader.read64((DataInput)sdi);
        this._primingFrames = BitstreamReader.read32(sdi);
        this._remainderFrames = BitstreamReader.read32(sdi);
        sdi.seek(beginDataPos + this._size);
    }

    public long numberPackets() {
        return this._numberPackets;
    }

    public long numberValidFrames() {
        return this._numberValidFrames;
    }

    public int primingFrames() {
        return this._primingFrames;
    }

    public int remainderFrames() {
        return this._remainderFrames;
    }
}

