/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.RIFF;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.RIFF.DescriptionListData;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class DescriptionListChunk
extends RiffChunkBase {
    private static long ENTRY_SIZE = 36L;
    private List<DescriptionListData> _entries = new ArrayList<DescriptionListData>();

    public DescriptionListChunk(String name, long offset, long size) {
        super(name, offset, size);
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        long orgPost = sdi.getFilePointer();
        long nEntries = this._size / ENTRY_SIZE;
        for (long ii = 0L; ii < nEntries; ++ii) {
            DescriptionListData data = new DescriptionListData();
            data._sampleRate = BitstreamReader.readFloat64(sdi);
            data._formatID = BitstreamReader.readFourCC((DataInput)sdi);
            data._flags = BitstreamReader.readU32((DataInput)sdi);
            data._bytesPerPacket = BitstreamReader.readU32((DataInput)sdi);
            data._framesPerPacket = BitstreamReader.readU32((DataInput)sdi);
            data._channelsPerFrame = BitstreamReader.readU32((DataInput)sdi);
            data._bitsPerChannel = BitstreamReader.readU32((DataInput)sdi);
            data._channelLayoutTag = BitstreamReader.readU32((DataInput)sdi);
            this._entries.add(data);
        }
        sdi.seek(orgPost + this._size);
    }

    public int entryCount() {
        return this._entries.size();
    }

    public List<DescriptionListData> entries() {
        return new ArrayList<DescriptionListData>(this._entries);
    }
}

