/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.RIFF;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class DataSize64Chunk
extends RiffChunkBase {
    public static final String NAME = "ds64";
    private long _riffSize = 0L;
    private long _dataSize = 0L;
    private long _sampleCount = 0L;
    private long _tableLen = 0L;
    private List<ChunkSize64> _chunkSizeTable = new ArrayList<ChunkSize64>();

    public DataSize64Chunk(String name, long offset, long size) {
        super(name, offset, size);
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        this._riffSize = BitstreamReader.read64LE((DataInput)sdi);
        this._dataSize = BitstreamReader.read64LE((DataInput)sdi);
        this._sampleCount = BitstreamReader.read64LE((DataInput)sdi);
        this._tableLen = BitstreamReader.readU32((DataInput)sdi);
        for (long ii = 0L; ii < this._tableLen; ++ii) {
            ChunkSize64 e = new ChunkSize64();
            e.id = BitstreamReader.readFourCC((DataInput)sdi);
            e.size = BitstreamReader.read64LE((DataInput)sdi);
            this._chunkSizeTable.add(e);
        }
    }

    public long riffSize() {
        return this._riffSize;
    }

    public long dataSize() {
        return this._dataSize;
    }

    public long sampleCount() {
        return this._sampleCount;
    }

    public long tableLen() {
        return this._tableLen;
    }

    public List<ChunkSize64> chunkSizeTable() {
        return this._chunkSizeTable;
    }

    public class ChunkSize64 {
        String id = "";
        long size = 0L;
    }
}

