/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.RIFF;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.audio.caf.CAChannelDescriptor;
import com.apple.jingle.leghorn.audio.caf.CAChannelLayoutTag;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ChannelChunk
extends RiffChunkBase {
    private long _channelLayoutTag = 0L;
    private long _channelBitmap = 0L;
    private long _numberChannelDescriptions = 0L;
    private List<CAChannelDescriptor> _channelDescriptions = new ArrayList<CAChannelDescriptor>();

    public ChannelChunk(String name, long offset, long size) {
        super(name, offset, size);
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        this._channelLayoutTag = BitstreamReader.readU32((DataInput)sdi);
        this._channelBitmap = BitstreamReader.readU32((DataInput)sdi);
        this._numberChannelDescriptions = BitstreamReader.readU32((DataInput)sdi);
        if (this._numberChannelDescriptions == 0L) {
            if (this._channelLayoutTag == CAChannelLayoutTag.UseChannelDescriptions.getValue()) {
                throw new IllegalStateException("Invalid number of channel descriptors");
            }
        } else {
            int ii = 0;
            while ((long)ii < this._numberChannelDescriptions) {
                CAChannelDescriptor desc = new CAChannelDescriptor();
                desc._channelLabel = BitstreamReader.readU32((DataInput)sdi);
                desc._channelFlags = BitstreamReader.readU32((DataInput)sdi);
                desc._coordinates[0] = BitstreamReader.readFloat32(sdi);
                desc._coordinates[1] = BitstreamReader.readFloat32(sdi);
                desc._coordinates[2] = BitstreamReader.readFloat32(sdi);
                this._channelDescriptions.add(desc);
                ++ii;
            }
        }
    }

    public long channelLayoutTag() {
        return this._channelLayoutTag;
    }

    public long channelBitmap() {
        return this._channelBitmap;
    }

    public long numberChannelDescriptions() {
        return this._numberChannelDescriptions;
    }

    public List<CAChannelDescriptor> channelDescriptions() {
        return this._channelDescriptions;
    }
}

