/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Mp3DescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    private static final byte[] FORWARDS_ID3 = new byte[]{73, 68, 51};
    private static final byte[] BACKWARDS_3DI = new byte[]{51, 68, 73};
    private static final byte[] MP3_MAGIC_NUMBER = new byte[]{-1, -5};
    private static final byte[] MP3_MAGIC_NUMBER_OLD = new byte[]{-1, -13};
    private String schemaName;

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        byte[] fileHeader = new byte[3];
        sdi.readFully(fileHeader);
        boolean isVerified = true;
        if (!(Arrays.equals(fileHeader, FORWARDS_ID3) || Arrays.equals(fileHeader, BACKWARDS_3DI) || MP3_MAGIC_NUMBER[0] == fileHeader[0] && MP3_MAGIC_NUMBER[1] == fileHeader[1] || MP3_MAGIC_NUMBER_OLD[0] == fileHeader[0] && MP3_MAGIC_NUMBER_OLD[1] == fileHeader[1])) {
            isVerified = false;
            listener.error(new ValidationError("Containertype doesn't match MP3", MediaValidationCode.AUD_CONTAINER_INCOMPATIBLE));
        }
        return isVerified;
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        SimpleContainerDescription containerDescription = new SimpleContainerDescription();
        if (!this.verifyContainerType(sdi, type, (ValidationListener)new ValidationsCollector())) {
            throw new IllegalArgumentException("File given does not match type: " + type.getName());
        }
        containerDescription.setDescriptionDocument(this.describe());
        return containerDescription;
    }

    private Document describe() {
        Document d = null;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return d;
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn MP3 Describer";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public static void main(String[] args) throws Exception {
        ContainerContainerDescriberRunner.main(new Mp3DescriberVerifier(), UniformTypeIdentifier.PUBLIC_MP3_AUDIO, args);
    }
}

