/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.BWF;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.BWF.BWFFile;
import com.apple.jingle.leghorn.audio.RIFF.BroadcastAudioExtensionChunk;
import com.apple.jingle.leghorn.audio.RIFF.ChannelAllocationChunk;
import com.apple.jingle.leghorn.audio.RIFF.DataChunk;
import com.apple.jingle.leghorn.audio.RIFF.DataSize64Chunk;
import com.apple.jingle.leghorn.audio.RIFF.FormatChunk;
import com.apple.jingle.leghorn.audio.RIFF.JunkChunk;
import com.apple.jingle.leghorn.audio.RIFF.RiffChunkBase;
import com.apple.jingle.leghorn.audio.RIFF.UnknownChunk;
import com.apple.jingle.leghorn.audio.RIFF.XMLChunk;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class BWFParser {
    protected static final Map<String, Class<? extends RiffChunkBase>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends RiffChunkBase>>();
    protected static final Logger loger = Logger.getLogger(BWFParser.class);
    private static final String RIFF64_MAGIC = "RF64";
    private static final String RIFF_MAGIC = "RIFF";

    public static void main(String[] args) throws Exception {
        String fileArgument = args[0];
        BWFParser parser = new BWFParser();
        URI uri = ContainerContainerDescriberRunner.uriForString(fileArgument);
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(fileArgument);
        BWFFile file = parser.parseFile((LeghornValidationContext)ctx, uri);
        String ss = file.xmlADM();
    }

    public BWFFile parseFile(@Nonnull LeghornValidationContext ctx, SeekableDataInput movieFile) throws IOException {
        return this.parseInput(ctx, movieFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWFFile parseFile(@Nonnull LeghornValidationContext ctx, URI movieFile) throws IOException {
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)movieFile);){
            BWFFile bWFFile = this.parseInput(ctx, sdi);
            return bWFFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWFFile parseFile(@Nonnull LeghornValidationContext ctx, File movieFile) throws IOException {
        try (FileSeekableDataInput sdi = new FileSeekableDataInput(movieFile.getAbsolutePath());){
            BWFFile bWFFile = this.parseInput(ctx, (SeekableDataInput)sdi);
            return bWFFile;
        }
    }

    public BWFFile parseInput(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        return this.parseInputInternal(ctx, sdi);
    }

    private BWFFile parseInputInternal(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        RiffChunkBase maybeXMLData;
        RiffChunkBase chunk;
        BWFFile waveFile = new BWFFile();
        if (sdi.length() < 1L) {
            ctx.addCheckAlert(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary);
            return waveFile;
        }
        String fileType = BitstreamReader.readFourCC((DataInput)sdi);
        if (!fileType.equals(RIFF64_MAGIC) && !fileType.equals(RIFF_MAGIC)) {
            ctx.addCheckAlert(MediaValidationCode.BWF_MAGIC_MISSING, MediaUtil.dictionary);
            return waveFile;
        }
        waveFile.setFileSize(sdi.length());
        long totalSizeDS64 = 0L;
        long dataSizeDS64 = 0L;
        boolean seenDataSize64Chunk = false;
        waveFile.setRiffMagic(fileType);
        waveFile.setRiffSize(BitstreamReader.readU32LE((DataInput)sdi));
        waveFile.setRiffFormat(BitstreamReader.readFourCC((DataInput)sdi));
        ArrayList<RiffChunkBase> chunkList = new ArrayList<RiffChunkBase>();
        while (sdi.getFilePointer() < sdi.length() && (chunk = this.readChunk(ctx, sdi)) != null) {
            if (chunk instanceof DataChunk && chunk.size() == 0xFFFFFFFFL) {
                if (!seenDataSize64Chunk) {
                    ctx.addCheckAlert(MediaValidationCode.BWF_DS64CHUNK_LOCATION_INVALID, MediaUtil.dictionary);
                    return waveFile;
                }
                ((DataChunk)chunk).updateSize(dataSizeDS64);
            }
            chunk.parse(ctx, sdi);
            if (chunk instanceof DataSize64Chunk) {
                totalSizeDS64 = ((DataSize64Chunk)chunk).riffSize();
                dataSizeDS64 = ((DataSize64Chunk)chunk).dataSize();
                seenDataSize64Chunk = true;
            }
            chunkList.add(chunk);
        }
        if (waveFile.riffSize() == 0xFFFFFFFFL) {
            if (!seenDataSize64Chunk) {
                ctx.addCheckAlert(MediaValidationCode.BWF_DS64CHUNK_MISSING, MediaUtil.dictionary);
                return waveFile;
            }
            waveFile.setRiffSize(totalSizeDS64);
        }
        if (chunkList.size() == 0) {
            ctx.addCheckAlert(MediaValidationCode.BWF_CHUNKS_MISSING, MediaUtil.dictionary);
            return waveFile;
        }
        RiffChunkBase maybeFormat = (RiffChunkBase)Iterables.find(chunkList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "fmt ".equals(riffChunkBase.name());
            }
        }, null);
        if (maybeFormat instanceof FormatChunk) {
            FormatChunk format = (FormatChunk)maybeFormat;
            waveFile.setBitsPerSample(format.bitsPerSample());
            waveFile.setFormatType(format.formatType());
            waveFile.setChannelCount(format.channelCount());
            waveFile.setSampleRate(format.sampleRate());
            waveFile.setByteAlignment(format.byteAlignment());
            waveFile.setBytesPerSecond(format.bytesPerSecond());
            waveFile.setFmtSize(format.size());
        } else {
            ctx.addCheckAlert(MediaValidationCode.BWF_FORMAT_MISSING, MediaUtil.dictionary);
        }
        RiffChunkBase maybeData = (RiffChunkBase)Iterables.find(chunkList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "data".equals(riffChunkBase.name());
            }
        }, null);
        if (maybeData instanceof DataChunk) {
            DataChunk dataChunk = (DataChunk)maybeData;
            waveFile.setDataSize(dataChunk.size());
        } else {
            ctx.addCheckAlert(MediaValidationCode.BWF_DATA_MISSING, MediaUtil.dictionary);
        }
        RiffChunkBase maybeChannelAlloc = (RiffChunkBase)Iterables.find(chunkList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "chna".equals(riffChunkBase.name());
            }
        }, null);
        if (maybeChannelAlloc instanceof ChannelAllocationChunk) {
            ChannelAllocationChunk channelAlloc = (ChannelAllocationChunk)maybeChannelAlloc;
            waveFile.setChannelAllocationList(channelAlloc.allocationList());
        }
        if ((maybeXMLData = (RiffChunkBase)Iterables.find(chunkList, (Predicate)new Predicate<RiffChunkBase>(){

            public boolean apply(@Nullable RiffChunkBase riffChunkBase) {
                return "axml".equals(riffChunkBase.name());
            }
        }, null)) instanceof XMLChunk) {
            XMLChunk XMLData = (XMLChunk)maybeXMLData;
            waveFile.setXmlADM(XMLData.xmldata());
        }
        return waveFile;
    }

    private RiffChunkBase readChunk(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        long curFilePos = sdi.getFilePointer();
        long remain = sdi.length() - curFilePos;
        if (remain < 8L) {
            return null;
        }
        String chkName = BitstreamReader.readFourCC((DataInput)sdi);
        long size = BitstreamReader.readU32LE((DataInput)sdi);
        if (size == -1L && "data".equals(chkName)) {
            size = sdi.length() - sdi.getFilePointer();
        }
        if (size < 0L) {
            throw new IllegalStateException("Invalid chunk size:" + size);
        }
        if (remain < size + 8L) {
            throw new IllegalStateException("Not enough bytes");
        }
        RiffChunkBase chunk = null;
        if (TYPE_CLASS_MAP.containsKey(chkName)) {
            try {
                Class<? extends RiffChunkBase> klass = TYPE_CLASS_MAP.get(chkName);
                Constructor<? extends RiffChunkBase> constructor = klass.getConstructor(String.class, Long.TYPE, Long.TYPE);
                chunk = constructor.newInstance(chkName, curFilePos, size);
            }
            catch (Exception e) {
                e.printStackTrace();
                loger.debug((Object)e);
            }
        } else {
            loger.debug((Object)("Not in TYPE_CLASS_MAP: " + chkName));
            chunk = new UnknownChunk(chkName, curFilePos, size);
        }
        return chunk;
    }

    static {
        TYPE_CLASS_MAP.put("JUNK", JunkChunk.class);
        TYPE_CLASS_MAP.put("ds64", DataSize64Chunk.class);
        TYPE_CLASS_MAP.put("data", DataChunk.class);
        TYPE_CLASS_MAP.put("fmt ", FormatChunk.class);
        TYPE_CLASS_MAP.put("chna", ChannelAllocationChunk.class);
        TYPE_CLASS_MAP.put("axml", XMLChunk.class);
        TYPE_CLASS_MAP.put("bext", BroadcastAudioExtensionChunk.class);
    }
}

