/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.BWF;

import com.apple.jingle.leghorn.audio.ADM.ADMData;
import com.apple.jingle.leghorn.audio.ADM.ChannelAllocationTable;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

public class BWFFile {
    private String _riffMagic = "";
    private String _riffFormat = "";
    private long _fileSize = 0L;
    private long _riffSize = 0L;
    private long _fmtSize = 0L;
    private long _dataSize = 0L;
    private int _formatType = 0;
    private int _channelCount = 0;
    private long _sampleRate = 0L;
    private long _bytesPerSecond = 0L;
    private int _byteAlignment = 0;
    private int _bitsPerSample = 0;
    private List<ChannelAllocationTable.ChannelAllocationEntry> _channelAllocationList = new ArrayList<ChannelAllocationTable.ChannelAllocationEntry>();
    private String _xmlAMD = "";
    private ADMData _ADMData = null;

    public int formatType() {
        return this._formatType;
    }

    public String formatTypeString() {
        switch (this._formatType) {
            case 1: {
                return "PCM";
            }
            case 3: {
                return "IEEE floating point";
            }
            case 6: {
                return "ALAW";
            }
            case 7: {
                return "MULAW";
            }
            case 65534: {
                return "Extensible";
            }
        }
        return "UNK";
    }

    public void setFormatType(int formatType) {
        this._formatType = formatType;
    }

    public int channelCount() {
        return this._channelCount;
    }

    public void setChannelCount(int channelCount) {
        this._channelCount = channelCount;
    }

    public long sampleRate() {
        return this._sampleRate;
    }

    public void setSampleRate(long sampleRate) {
        this._sampleRate = sampleRate;
    }

    public long bytesPerSecond() {
        return this._bytesPerSecond;
    }

    public void setBytesPerSecond(long bytesPerSecond) {
        this._bytesPerSecond = bytesPerSecond;
    }

    public int byteAlignment() {
        return this._byteAlignment;
    }

    public void setByteAlignment(int byteAlignment) {
        this._byteAlignment = byteAlignment;
    }

    public int bitsPerSample() {
        return this._bitsPerSample;
    }

    public void setBitsPerSample(int bitsPerSample) {
        this._bitsPerSample = bitsPerSample;
    }

    public long fileSize() {
        return this._fileSize;
    }

    public void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    public long riffSize() {
        return this._riffSize;
    }

    public void setRiffSize(long riffSize) {
        this._riffSize = riffSize;
    }

    public long dataSize() {
        return this._dataSize;
    }

    public void setDataSize(long dataSize) {
        this._dataSize = dataSize;
    }

    public long fmtSize() {
        return this._fmtSize;
    }

    public void setFmtSize(long fmtSize) {
        this._fmtSize = fmtSize;
    }

    public String riffFormat() {
        return this._riffFormat;
    }

    public void setRiffFormat(String riffFormat) {
        this._riffFormat = riffFormat;
    }

    public String riffMagic() {
        return this._riffMagic;
    }

    public void setRiffMagic(String riffMagic) {
        this._riffMagic = riffMagic;
    }

    public List<ChannelAllocationTable.ChannelAllocationEntry> channelAllocationList() {
        return this._channelAllocationList;
    }

    public void setChannelAllocationList(List<ChannelAllocationTable.ChannelAllocationEntry> allocationList) {
        this._channelAllocationList = allocationList;
    }

    public String xmlADM() {
        return this._xmlAMD;
    }

    public void setXmlADM(String xmlString) {
        this._xmlAMD = xmlString;
    }

    public boolean hasXmlADM() {
        return !Strings.isNullOrEmpty((String)this._xmlAMD);
    }

    public ADMData ADMData() {
        return this._ADMData;
    }

    public void setADMData(ADMData data) {
        this._ADMData = data;
    }

    public boolean hasADMData() {
        return this._ADMData != null;
    }

    public double durationSeconds() {
        if (this._bytesPerSecond == 0L) {
            return 0.0;
        }
        return (double)this._dataSize / (double)this._bytesPerSecond;
    }
}

