/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio;

import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.BitReader;
import com.apple.jingle.leghorn.audio.wav.WavValidationService;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AudioDescriberApplication {
    private static final Logger logger = Logger.getLogger(AudioDescriberApplication.class);
    private static int counter = 0;
    private boolean local;
    private String path;

    public static void main(String[] args) {
        long outerStart = 0L;
        long outerTime = 0L;
        AudioDescriberApplication tester = new AudioDescriberApplication();
        outerStart = System.currentTimeMillis();
        if (args.length != 1) {
            AudioDescriberApplication.usage();
        }
        tester.setPath(args[0]);
        tester.describe(tester.path);
        outerTime = System.currentTimeMillis() - outerStart;
        System.out.println("Total time to describe " + counter + " files: " + (double)outerTime / 1000.0 + " seconds");
    }

    private void describe(String path) {
        String[] filenames;
        for (String filename : filenames = new File(path).list()) {
            File thisFile = new File(path + filename);
            if (thisFile.isHidden()) continue;
            if (thisFile.isDirectory()) {
                this.describe(thisFile.getPath() + "/");
                continue;
            }
            this.describe(thisFile);
        }
    }

    private void describe(File file) {
        ValidationService service = null;
        long start = 0L;
        long stop = 0L;
        String filename = file.getName();
        try {
            this.setPath(file.getParentFile().getPath() + "/");
            FileSeekableDataInput sdi = new FileSeekableDataInput(file);
            service = this.getType(filename) == 0 ? new WavValidationService((SeekableDataInput)sdi, null, true, "com.microsoft.waveform-audio", "WAV Audio file") : new FlacValidationService((SeekableDataInput)sdi, null, true, "org.xiph.flac", "FLAC Audio File");
            service.setPath(this.path);
            start = System.currentTimeMillis();
            service.validate();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BitReader.HitEndOfFileException ignored) {
            stop = System.currentTimeMillis();
            System.out.println("Described file " + filename + " in " + (double)(stop - start) / 1000.0 + " seconds");
        }
        catch (AudioDescriptionException e) {
            System.out.println("Format exception in " + filename + ": " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++counter;
    }

    private int getType(String filename) {
        String[] split = filename.split("[.]");
        String extension = split[split.length - 1];
        return extension.equals("wav") ? 0 : 1;
    }

    private void setPath(String path) {
        this.path = path;
    }

    private static void usage() {
        System.err.println("Please provide a single string argument: path where files to describe reside");
    }
}

