/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.PackFormat;
import com.apple.jingle.leghorn.audio.ADM.TrackFormat;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class TrackUID
implements ADMParserNode {
    private String _UID = "";
    private String _sampleRate = "";
    private String _bitDepth = "";
    private Map<String, PackFormat> _packFormats = new HashMap<String, PackFormat>();
    private Map<String, TrackFormat> _trackFormats = new HashMap<String, TrackFormat>();

    public TrackUID(@Nonnull String UID, @Nonnull String sampleRate, @Nonnull String bitDepth) {
        this._UID = UID;
        this._sampleRate = sampleRate;
        this._bitDepth = bitDepth;
    }

    public String UID() {
        return this._UID;
    }

    public void addPackFormatKey(String id) {
        this._packFormats.put(id, null);
    }

    public void addPackFormat(PackFormat c) {
        if (!this._packFormats.containsKey(c.id())) {
            throw new IllegalStateException("The AudioObject does know about the PackFormat key:" + c.id());
        }
        if (this._packFormats.get(c.id()) != null) {
            throw new IllegalStateException("The PackFormat key:" + c.id() + " was set already");
        }
        this._packFormats.put(c.id(), c);
    }

    public Collection<String> packFormatIDs() {
        return this._packFormats.keySet();
    }

    public void addTrackFormatKey(String id) {
        this._trackFormats.put(id, null);
    }

    public void addTrackFormat(TrackFormat c) {
        if (!this._trackFormats.containsKey(c.id())) {
            throw new IllegalStateException("The AudioObject does know about the PackFormat key:" + c.id());
        }
        if (this._trackFormats.get(c.id()) != null) {
            throw new IllegalStateException("The PackFormat key:" + c.id() + " was set already");
        }
        this._trackFormats.put(c.id(), c);
    }

    public Collection<String> trackFormatIDs() {
        return this._trackFormats.keySet();
    }

    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (this._UID != null) {
            if (this._UID.length() != 12) {
                ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "TrackUID").add("id", this._UID));
                return false;
            }
            if (!this._UID.startsWith("ATU_")) {
                ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "TrackUID").add("id", this._UID));
                return false;
            }
        } else {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_MISSING, MediaUtil.dictionary.add("name", "some TrackUID object"));
        }
        return true;
    }
}

