/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMFormat;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.StreamFormat;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;

public class TrackFormat
extends ADMFormat
implements ADMParserNode {
    private String _streamFormatRef = "";
    private StreamFormat _streamFormat;

    public TrackFormat(@Nonnull String id, @Nonnull String name, @Nonnull String label, @Nonnull String definition) {
        super(id, name, label, definition);
    }

    public void setStreamFormatKey(String id) {
        this._streamFormatRef = id;
    }

    public void setStreamFormat(StreamFormat c) {
        if (Strings.isNullOrEmpty((String)this._streamFormatRef)) {
            throw new IllegalStateException("The call setStreamFormatKey first");
        }
        if (!this._streamFormatRef.equals(c.id())) {
            throw new IllegalStateException("The invalid StreamFormat key:" + c.id() + ". Expected:" + this._streamFormatRef);
        }
        this._streamFormat = c;
    }

    public String streamFormatID() {
        return this._streamFormatRef;
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 14) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "TrackFormat").add("id", id));
            return false;
        }
        if (!id.startsWith("AT_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "TrackFormat").add("id", id));
            return false;
        }
        int idVal = Integer.valueOf(id.substring(7, 11), 16);
        if (4096 > idVal || idVal > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "TrackFormat").add("id", id));
            return false;
        }
        return true;
    }
}

