/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMFormat;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.ChannelFormat;
import com.apple.jingle.leghorn.audio.ADM.PackFormat;
import com.apple.jingle.leghorn.audio.ADM.TrackFormat;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class StreamFormat
extends ADMFormat
implements ADMParserNode {
    private String _channelFormatRef = "";
    private ChannelFormat _channelFormat;
    private String _packFormatRef = "";
    private PackFormat _packFormat;
    private Map<String, TrackFormat> _trackFormats = new HashMap<String, TrackFormat>();

    public StreamFormat(@Nonnull String id, @Nonnull String name, @Nonnull String label, @Nonnull String definition) {
        super(id, name, label, definition);
    }

    public void setPackFormatKey(String id) {
        this._packFormatRef = id;
    }

    public void setPackFormat(PackFormat c) {
        if (Strings.isNullOrEmpty((String)this._packFormatRef)) {
            throw new IllegalStateException("The call setPackFormatKey first");
        }
        if (!this._packFormatRef.equals(c.id())) {
            throw new IllegalStateException("The invalid PackFormat key:" + c.id() + ". Expected:" + this._packFormatRef);
        }
        this._packFormat = c;
    }

    public String packFormatID() {
        return this._packFormatRef;
    }

    public void setChannelFormatKey(String id) {
        this._channelFormatRef = id;
    }

    public void setChannelFormat(ChannelFormat c) {
        if (Strings.isNullOrEmpty((String)this._channelFormatRef)) {
            throw new IllegalStateException("The call setChannelFormatKey first");
        }
        if (!this._channelFormatRef.equals(c.id())) {
            throw new IllegalStateException("The invalid ChannelFormat key:" + c.id() + ". Expected:" + this._channelFormatRef);
        }
        this._channelFormat = c;
    }

    public String channelFormatID() {
        return this._channelFormatRef;
    }

    public void addTrackFormatKey(String id) {
        this._trackFormats.put(id, null);
    }

    public void addTrackFormat(TrackFormat c) {
        if (!this._trackFormats.containsKey(c.id())) {
            throw new IllegalStateException("The AudioObject does know about the PackFormat key:" + c.id());
        }
        if (this._trackFormats.get(c.id()) != null) {
            throw new IllegalStateException("The PackFormat key:" + c.id() + " was set already");
        }
        this._trackFormats.put(c.id(), c);
    }

    public Collection<String> trackFormatIDs() {
        return this._trackFormats.keySet();
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 11) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "StreamFormat").add("id", id));
            return false;
        }
        if (!id.startsWith("AS_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "StreamFormat").add("id", id));
            return false;
        }
        int idVal = Integer.valueOf(id.substring(7, 11), 16);
        if (4096 > idVal || idVal > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "StreamFormat").add("id", id));
            return false;
        }
        return true;
    }
}

