/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMNamedObject;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.Content;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Programme
extends ADMNamedObject
implements ADMParserNode {
    private String _language = "";
    private String _start = "";
    private String _end = "";
    private Map<String, Content> _content = new HashMap<String, Content>();

    public void addContentKey(String id) {
        this._content.put(id, null);
    }

    public void addContent(Content c) {
        if (!this._content.containsKey(c.id())) {
            throw new IllegalStateException("The program does know about the content key:" + c.id());
        }
        if (this._content.get(c.id()) != null) {
            throw new IllegalStateException("The content key:" + c.id() + " was set already");
        }
        this._content.put(c.id(), c);
    }

    public Programme(@Nonnull String id, @Nonnull String name) {
        super(id, name);
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 8) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Programme").add("id", id));
            return false;
        }
        if (!id.startsWith("APR_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Programme").add("id", id));
            return false;
        }
        int val = Integer.valueOf(id.substring(4), 16);
        if (4096 > val || val > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Programme").add("id", id));
            return false;
        }
        return true;
    }
}

