/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMFormat;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.ChannelFormat;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class PackFormat
extends ADMFormat
implements ADMParserNode {
    private int _importance = -1;
    private double _absoluteDistance = Double.MIN_VALUE;
    private Map<String, ChannelFormat> _channelFormats = new HashMap<String, ChannelFormat>();
    private Map<String, PackFormat> _packFormats = new HashMap<String, PackFormat>();

    public PackFormat(@Nonnull String id, @Nonnull String name, @Nonnull String label, @Nonnull String definition) {
        super(id, name, label, definition);
    }

    public void addChannelFormatKey(String id) {
        this._channelFormats.put(id, null);
    }

    public void addChannelFormat(ChannelFormat c) {
        if (!this._channelFormats.containsKey(c.id())) {
            throw new IllegalStateException("The PackFormat does know about the ChannelFormat key:" + c.id());
        }
        if (this._channelFormats.get(c.id()) != null) {
            throw new IllegalStateException("The ChannelFormat key:" + c.id() + " was set already");
        }
        this._channelFormats.put(c.id(), c);
    }

    public Collection<String> channelFormatIDs() {
        return this._channelFormats.keySet();
    }

    public void addPackFormatKey(String id) {
        this._packFormats.put(id, null);
    }

    public void addPackFormat(PackFormat c) {
        if (!this._packFormats.containsKey(c.id())) {
            throw new IllegalStateException("The AudioObject does know about the PackFormat key:" + c.id());
        }
        if (this._packFormats.get(c.id()) != null) {
            throw new IllegalStateException("The PackFormat key:" + c.id() + " was set already");
        }
        this._packFormats.put(c.id(), c);
    }

    public Collection<String> packFormatIDs() {
        return this._packFormats.keySet();
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 11) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "PackFormat").add("id", id));
            return false;
        }
        if (!id.startsWith("AP_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "PackFormat").add("id", id));
            return false;
        }
        int idVal = Integer.valueOf(id.substring(7, 11), 16);
        if (4096 > idVal || idVal > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "PackFormat").add("id", id));
            return false;
        }
        return true;
    }
}

