/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMNamedObject;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.AudioObject;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Content
extends ADMNamedObject
implements ADMParserNode {
    private String _language = "";
    private int _dialoge = -1;
    private Map<String, AudioObject> _audioObjects = new HashMap<String, AudioObject>();

    public Content(@Nonnull String id, @Nonnull String name) {
        super(id, name);
    }

    public void addAudioObjectKey(String id) {
        this._audioObjects.put(id, null);
    }

    public void addAudioObject(AudioObject c) {
        if (!this._audioObjects.containsKey(c.id())) {
            throw new IllegalStateException("The program does know about the content key:" + c.id());
        }
        if (this._audioObjects.get(c.id()) != null) {
            throw new IllegalStateException("The content key:" + c.id() + " was set already");
        }
        this._audioObjects.put(c.id(), c);
    }

    public int audioObjectsCount() {
        return this._audioObjects.size();
    }

    public Collection<String> audioObjectIDs() {
        return this._audioObjects.keySet();
    }

    public Collection<AudioObject> audioObjects() {
        return this._audioObjects.values();
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 8) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Content").add("id", id));
            return false;
        }
        if (!id.startsWith("ACO_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Content").add("id", id));
            return false;
        }
        int val = Integer.valueOf(id.substring(4), 16);
        if (4096 > val || val > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "Content").add("id", id));
            return false;
        }
        return true;
    }
}

