/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMFormat;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.BlockFormat;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ChannelFormat
extends ADMFormat
implements ADMParserNode {
    private Map<String, BlockFormat> _blockFormats = new HashMap<String, BlockFormat>();
    private String _highFrequency = "";
    private String _lowFrequency = "";

    public ChannelFormat(@Nonnull String id, @Nonnull String name, @Nonnull String label, @Nonnull String definition) {
        super(id, name, label, definition);
    }

    public void addBlockFormat(BlockFormat c) {
        if (this._blockFormats.get(c.id()) != null) {
            throw new IllegalStateException("The BlockFormat key:" + c.id() + " was set already");
        }
        c.setParent(this);
        this._blockFormats.put(c.id(), c);
    }

    public Collection<String> blockFormatIDs() {
        return this._blockFormats.keySet();
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 11) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "ChannelFormat").add("id", id));
            return false;
        }
        if (!id.startsWith("AC_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "ChannelFormat").add("id", id));
            return false;
        }
        int idVal = Integer.valueOf(id.substring(7, 11), 16);
        if (4096 > idVal || idVal > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "ChannelFormat").add("id", id));
            return false;
        }
        return true;
    }
}

