/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMNamedObject;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.ADMUtil;
import com.apple.jingle.leghorn.audio.ADM.PackFormat;
import com.apple.jingle.leghorn.audio.ADM.TimeInterval;
import com.apple.jingle.leghorn.audio.ADM.TrackUID;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class AudioObject
extends ADMNamedObject
implements ADMParserNode {
    private long _start = 0L;
    private long _duration = 0L;
    private int _dialoge = -1;
    private int _importance = -1;
    private int _interact = -1;
    private Map<String, AudioObject> _audioObjects = new HashMap<String, AudioObject>();
    private Map<String, PackFormat> _packFormats = new HashMap<String, PackFormat>();
    private Map<String, TrackUID> _trackUIDs = new HashMap<String, TrackUID>();

    public AudioObject(@Nonnull String id, @Nonnull String name) {
        super(id, name);
    }

    public void setStart(@Nonnull String start) {
        this._start = ADMUtil.stringToNanoSeconds(start);
    }

    public long start() {
        return this._start;
    }

    public void setDuration(@Nonnull String duration) {
        this._duration = ADMUtil.stringToNanoSeconds(duration);
    }

    public long duration() {
        return this._duration;
    }

    public TimeInterval timeInterval() {
        return new TimeInterval(this._start, this._duration);
    }

    public void addPackFormatKey(String id) {
        this._packFormats.put(id, null);
    }

    public void addPackFormat(PackFormat c) {
        if (!this._packFormats.containsKey(c.id())) {
            throw new IllegalStateException("The AudioObject does know about the PackFormat key:" + c.id());
        }
        if (this._packFormats.get(c.id()) != null) {
            throw new IllegalStateException("The PackFormat key:" + c.id() + " was set already");
        }
        this._packFormats.put(c.id(), c);
    }

    public Collection<String> packFormatIDs() {
        return this._packFormats.keySet();
    }

    public void addTrackUIDKey(String id) {
        this._trackUIDs.put(id, null);
    }

    public void addTrackUID(TrackUID c) {
        if (!this._trackUIDs.containsKey(c.UID())) {
            throw new IllegalStateException("The AudioObject does know about the TrackUID key:" + c.UID());
        }
        if (this._trackUIDs.get(c.UID()) != null) {
            throw new IllegalStateException("The TrackUID key:" + c.UID() + " was set already");
        }
        this._trackUIDs.put(c.UID(), c);
    }

    public Collection<String> trackUIDs() {
        return this._trackUIDs.keySet();
    }

    public void addAudioObjectKey(String id) {
        this._audioObjects.put(id, null);
    }

    public void addAudioObject(AudioObject c) {
        if (!this._audioObjects.containsKey(c.id())) {
            throw new IllegalStateException("The program does know about the content key:" + c.id());
        }
        if (this._audioObjects.get(c.id()) != null) {
            throw new IllegalStateException("The content key:" + c.id() + " was set already");
        }
        this._audioObjects.put(c.id(), c);
    }

    public Collection<String> audioObjectIDs() {
        return this._audioObjects.keySet();
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        String id = this.id();
        if (id.length() != 7) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "AudioObject").add("id", id));
            return false;
        }
        if (!id.startsWith("AO_")) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "AudioObject").add("id", id));
            return false;
        }
        int val = Integer.valueOf(id.substring(3), 16);
        if (4096 > val || val > 65535) {
            ctx.addCheckAlert(MediaValidationCode.ADM_ID_INVALID, MediaUtil.dictionary.add("kind", "AudioObject").add("id", id));
            return false;
        }
        return true;
    }
}

