/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMData;
import com.apple.jingle.leghorn.audio.ADM.ADMParserNode;
import com.apple.jingle.leghorn.audio.ADM.AudioObject;
import com.apple.jingle.leghorn.audio.ADM.BlockFormat;
import com.apple.jingle.leghorn.audio.ADM.ChannelFormat;
import com.apple.jingle.leghorn.audio.ADM.Content;
import com.apple.jingle.leghorn.audio.ADM.PackFormat;
import com.apple.jingle.leghorn.audio.ADM.Programme;
import com.apple.jingle.leghorn.audio.ADM.StreamFormat;
import com.apple.jingle.leghorn.audio.ADM.TimeInterval;
import com.apple.jingle.leghorn.audio.ADM.TrackFormat;
import com.apple.jingle.leghorn.audio.ADM.TrackUID;
import com.apple.jingle.leghorn.audio.BWF.BWFFile;
import com.apple.jingle.leghorn.audio.BWF.BWFParser;
import com.apple.jingle.leghorn.audio.BWF.BWFValidationContext;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ADMParser {
    private static ADMData _standardDefinitions = null;

    public static void main(String[] args) throws Exception {
        ADMParser admParser = new ADMParser();
        String fileArgument = args[0];
        BWFValidationContext ctx = new BWFValidationContext(fileArgument);
        BWFParser parser = new BWFParser();
        URI uri = ContainerContainerDescriberRunner.uriForString(fileArgument);
        BWFFile file = parser.parseFile((LeghornValidationContext)ctx, uri);
        ADMData data = admParser.parse((LeghornValidationContext)ctx, file.xmlADM());
        List<TimeInterval> durationIntervals = data.getFlatenDurationIntervals();
        if (durationIntervals.size() > 1) {
            System.out.println("There are gaps");
        }
        for (TimeInterval ti : durationIntervals) {
            System.out.println(ti.prettyString());
        }
    }

    private ADMData getStandardDefinitions(@Nonnull LeghornValidationContext ctx) {
        InputStream standardDefinitionsFileStream;
        if (_standardDefinitions == null && (standardDefinitionsFileStream = this.getClass().getResourceAsStream("standarddefinitions.xml")) != null) {
            _standardDefinitions = this.parse(ctx, standardDefinitionsFileStream);
        }
        return _standardDefinitions;
    }

    public ADMData parse(@Nonnull LeghornValidationContext ctx, @Nonnull InputStream inputStream) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            UserHandler userhandler = new UserHandler(ctx);
            saxParser.parse(inputStream, (DefaultHandler)userhandler);
            userhandler.getADMData().postProcess(ctx);
            return userhandler.getADMData();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ADMData parse(@Nonnull LeghornValidationContext ctx, @Nonnull String ss) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(ss.getBytes("UTF-8"));
            return this.parse(ctx, stream);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public class UserHandler
    extends DefaultHandler {
        private static final String ebuCoreMainElement = "ebuCoreMain";
        private static final String coreMetadataElement = "coreMetadata";
        private static final String formatElement = "format";
        private static final String audioFormatExtendedElement = "audioFormatExtended";
        private static final String programmeElement = "audioProgramme";
        private static final String contentIDRefElement = "audioContentIDRef";
        private static final String contentElement = "audioContent";
        private static final String audioObjectIDRefElement = "audioObjectIDRef";
        private static final String audioObjectElement = "audioObject";
        private static final String packFormatIDRefElement = "audioPackFormatIDRef";
        private static final String packFormatElement = "audioPackFormat";
        private static final String trackUIDRefElement = "audioTrackUIDRef";
        private static final String trackUIDElement = "audioTrackUID";
        private static final String trackFormatIDRefElement = "audioTrackFormatIDRef";
        private static final String trackFormatElement = "audioTrackFormat";
        private static final String streamFormatIDRefElement = "audioStreamFormatIDRef";
        private static final String streamFormatElement = "audioStreamFormat";
        private static final String channelFormatIDRefElement = "audioChannelFormatIDRef";
        private static final String channelFormatElement = "audioChannelFormat";
        private static final String blockFormatElement = "audioBlockFormat";
        private static final String bfCartesianElement = "cartesian";
        private static final String bfPolarElement = "polar";
        private static final String bfJumpPositionElement = "jumpPosition";
        private static final String bfPositionElement = "position";
        private Set<String> _popableElements = new HashSet<String>();
        private boolean ebuCoreMainElementFound = false;
        private boolean coreMetadataElementFound = false;
        private boolean formatElementFound = false;
        private boolean audioFormatExtendedElementFound = false;
        private Stack<String> _stateStack = new Stack();
        private Stack<ADMParserNode> _nodeStack = new Stack();
        private ADMData _ADMData = new ADMData();
        private String _currentLabelForPosition = "";
        private String _currentInterpolationLength = "";
        private LeghornValidationContext _vctx = null;

        UserHandler(LeghornValidationContext ctx) {
            this._vctx = ctx;
        }

        private Programme buildProgramme(Attributes attributes) {
            String id = attributes.getValue("audioProgrammeID");
            String name = attributes.getValue("audioProgrammeName");
            return new Programme(id, name);
        }

        private AudioObject buildAudioObject(Attributes attributes) {
            String id = attributes.getValue("audioObjectID");
            String name = attributes.getValue("audioObjectName");
            AudioObject o = new AudioObject(id, name);
            o.setStart(attributes.getValue("startTime"));
            o.setDuration(attributes.getValue("duration"));
            return o;
        }

        private PackFormat buildPackFormat(Attributes attributes) {
            String id = attributes.getValue("audioPackFormatID");
            String name = attributes.getValue("audioPackFormatName");
            String label = attributes.getValue("typeLabel");
            String definition = attributes.getValue("typeDefinition");
            return new PackFormat(id, name, label, definition);
        }

        private ChannelFormat buildChannelFormat(Attributes attributes) {
            String id = attributes.getValue("audioChannelFormatID");
            String name = attributes.getValue("audioChannelFormatName");
            String label = attributes.getValue("typeLabel");
            String definition = attributes.getValue("typeDefinition");
            return new ChannelFormat(id, name, label, definition);
        }

        private BlockFormat buildBlockFormat(Attributes attributes) {
            String id = attributes.getValue("audioBlockFormatID");
            String rtime = attributes.getValue("rtime");
            String duration = attributes.getValue("duration");
            return new BlockFormat(id, rtime, duration);
        }

        private TrackUID buildTrackUID(Attributes attributes) {
            String id = attributes.getValue("UID");
            String sampleRate = attributes.getValue("sampleRate");
            String bitDepth = attributes.getValue("bitDepth");
            return new TrackUID(id, sampleRate, bitDepth);
        }

        private TrackFormat buildTrackFormat(Attributes attributes) {
            String id = attributes.getValue("audioTrackFormatID");
            String name = attributes.getValue("audioTrackFormatName");
            String label = attributes.getValue("typeLabel");
            String definition = attributes.getValue("typeDefinition");
            String formatLabel = attributes.getValue("formatLabel");
            String formatDefinition = attributes.getValue("formatDefinition");
            return new TrackFormat(id, name, label, definition);
        }

        private StreamFormat buildStreamFormat(Attributes attributes) {
            String id = attributes.getValue("audioStreamFormatID");
            String name = attributes.getValue("audioStreamFormatID");
            String label = attributes.getValue("typeLabel");
            String definition = attributes.getValue("typeDefinition");
            String formatLabel = attributes.getValue("formatLabel");
            String formatDefinition = attributes.getValue("formatDefinition");
            return new StreamFormat(id, name, label, definition);
        }

        private Content buildContent(Attributes attributes) {
            String id = attributes.getValue("audioContentID");
            String name = attributes.getValue("audioContentName");
            return new Content(id, name);
        }

        public ADMData getADMData() {
            return this._ADMData;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this._popableElements.add(programmeElement);
            this._popableElements.add(contentElement);
            this._popableElements.add(audioObjectElement);
            this._popableElements.add(packFormatElement);
            this._popableElements.add(channelFormatElement);
            this._popableElements.add(trackUIDElement);
            this._popableElements.add(trackFormatElement);
            this._popableElements.add(streamFormatElement);
            this._popableElements.add(blockFormatElement);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this._stateStack.push(qName);
            if (ebuCoreMainElement.equals(qName)) {
                this.ebuCoreMainElementFound = true;
            }
            if (this.ebuCoreMainElementFound && coreMetadataElement.equals(qName)) {
                this.coreMetadataElementFound = true;
            }
            if (this.coreMetadataElementFound && formatElement.equals(qName)) {
                this.formatElementFound = true;
            }
            if (this.formatElementFound && audioFormatExtendedElement.equals(qName)) {
                this.audioFormatExtendedElementFound = true;
            }
            if (!this.audioFormatExtendedElementFound) {
                return;
            }
            if (qName.equals(programmeElement)) {
                this._nodeStack.push(this.buildProgramme(attributes));
            }
            if (qName.equals(contentElement)) {
                Content content = this.buildContent(attributes);
                this._ADMData.addContent(content);
                this._nodeStack.push(content);
            }
            if (qName.equals(audioObjectElement)) {
                AudioObject audioObject = this.buildAudioObject(attributes);
                this._ADMData.addAudioObject(audioObject);
                this._nodeStack.push(audioObject);
            }
            if (qName.equals(packFormatElement)) {
                PackFormat packFormat = this.buildPackFormat(attributes);
                this._ADMData.addPackFormat(packFormat);
                this._nodeStack.push(packFormat);
            }
            if (qName.equals(channelFormatElement)) {
                ChannelFormat channelFormat = this.buildChannelFormat(attributes);
                this._ADMData.addChannelFormat(channelFormat);
                this._nodeStack.push(channelFormat);
            }
            if (qName.equals(blockFormatElement) && this._nodeStack.peek() instanceof ChannelFormat) {
                ChannelFormat cf = (ChannelFormat)this._nodeStack.peek();
                BlockFormat blockFormat = this.buildBlockFormat(attributes);
                cf.addBlockFormat(blockFormat);
                this._nodeStack.push(blockFormat);
            }
            if (qName.equals(trackUIDElement)) {
                TrackUID trackUID = this.buildTrackUID(attributes);
                this._ADMData.addTrackUID(trackUID);
                this._nodeStack.push(trackUID);
            }
            if (qName.equals(trackFormatElement)) {
                TrackFormat trackFormat = this.buildTrackFormat(attributes);
                this._ADMData.addTrackFormat(trackFormat);
                this._nodeStack.push(trackFormat);
            }
            if (qName.equals(streamFormatElement)) {
                StreamFormat streamFormat = this.buildStreamFormat(attributes);
                this._ADMData.addStreamFormat(streamFormat);
                this._nodeStack.push(streamFormat);
            }
            if (qName.equals(bfCartesianElement)) {
                // empty if block
            }
            if (qName.equals(bfPolarElement)) {
                // empty if block
            }
            if (qName.equals(bfJumpPositionElement)) {
                this._currentInterpolationLength = attributes.getValue("interpolationLength");
            }
            if (qName.equals(bfPositionElement)) {
                this._currentLabelForPosition = attributes.getValue("coordinate");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this._stateStack.pop();
            if (this._popableElements.contains(qName)) {
                this._nodeStack.pop();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (contentIDRefElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof Programme)) throw new IllegalStateException();
                ((Programme)this._nodeStack.peek()).addContentKey(new String(ch, start, length));
                return;
            } else if (audioObjectIDRefElement.equals(this._stateStack.peek())) {
                if (this._nodeStack.peek() instanceof Content) {
                    ((Content)this._nodeStack.peek()).addAudioObjectKey(new String(ch, start, length));
                    return;
                } else {
                    if (!(this._nodeStack.peek() instanceof AudioObject)) throw new IllegalStateException();
                    ((AudioObject)this._nodeStack.peek()).addAudioObjectKey(new String(ch, start, length));
                }
                return;
            } else if (packFormatIDRefElement.equals(this._stateStack.peek())) {
                if (this._nodeStack.peek() instanceof AudioObject) {
                    ((AudioObject)this._nodeStack.peek()).addPackFormatKey(new String(ch, start, length));
                    return;
                } else if (this._nodeStack.peek() instanceof TrackUID) {
                    ((TrackUID)this._nodeStack.peek()).addPackFormatKey(new String(ch, start, length));
                    return;
                } else if (this._nodeStack.peek() instanceof StreamFormat) {
                    ((StreamFormat)this._nodeStack.peek()).setPackFormatKey(new String(ch, start, length));
                    return;
                } else {
                    if (!(this._nodeStack.peek() instanceof PackFormat)) throw new IllegalStateException();
                    ((PackFormat)this._nodeStack.peek()).addPackFormatKey(new String(ch, start, length));
                }
                return;
            } else if (trackUIDRefElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof AudioObject)) throw new IllegalStateException();
                ((AudioObject)this._nodeStack.peek()).addTrackUIDKey(new String(ch, start, length));
                return;
            } else if (channelFormatIDRefElement.equals(this._stateStack.peek())) {
                if (this._nodeStack.peek() instanceof PackFormat) {
                    ((PackFormat)this._nodeStack.peek()).addChannelFormatKey(new String(ch, start, length));
                    return;
                } else {
                    if (!(this._nodeStack.peek() instanceof StreamFormat)) throw new IllegalStateException();
                    ((StreamFormat)this._nodeStack.peek()).setChannelFormatKey(new String(ch, start, length));
                }
                return;
            } else if (trackFormatIDRefElement.equals(this._stateStack.peek())) {
                if (this._nodeStack.peek() instanceof TrackUID) {
                    ((TrackUID)this._nodeStack.peek()).addTrackFormatKey(new String(ch, start, length));
                    return;
                } else {
                    if (!(this._nodeStack.peek() instanceof StreamFormat)) throw new IllegalStateException();
                    ((StreamFormat)this._nodeStack.peek()).addTrackFormatKey(new String(ch, start, length));
                }
                return;
            } else if (streamFormatIDRefElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof TrackFormat)) throw new IllegalStateException();
                ((TrackFormat)this._nodeStack.peek()).setStreamFormatKey(new String(ch, start, length));
                return;
            } else if (bfCartesianElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof BlockFormat)) throw new IllegalStateException();
                ((BlockFormat)this._nodeStack.peek()).setCartesian(Boolean.valueOf(new String(ch, start, length)));
                return;
            } else if (bfPolarElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof BlockFormat)) throw new IllegalStateException();
                ((BlockFormat)this._nodeStack.peek()).setPolar(Boolean.valueOf(new String(ch, start, length)));
                return;
            } else if (bfPositionElement.equals(this._stateStack.peek())) {
                if (!(this._nodeStack.peek() instanceof BlockFormat)) throw new IllegalStateException();
                ((BlockFormat)this._nodeStack.peek()).setPosition(this._currentLabelForPosition, Double.valueOf(new String(ch, start, length)));
                return;
            } else {
                if (!bfJumpPositionElement.equals(this._stateStack.peek())) return;
                if (!(this._nodeStack.peek() instanceof BlockFormat)) throw new IllegalStateException();
                ((BlockFormat)this._nodeStack.peek()).setJumpPosition(Boolean.valueOf(new String(ch, start, length)), Double.valueOf(this._currentInterpolationLength));
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            super.warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            super.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
        }
    }
}

