/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.ADMNamedObject;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class ADMFormat
extends ADMNamedObject {
    private String _label = "";
    private TypeDefinition _definition = TypeDefinition.Invalid;
    private String _definitionStr = "";
    private static Set<String> _validLabels = new HashSet<String>();

    public ADMFormat(@Nonnull String id, @Nonnull String name, @Nonnull String label, @Nonnull String definition) {
        super(id, name);
        this._label = label;
        this._definitionStr = definition;
        this._definition = this.stringToTypeDefinition(this._definitionStr);
    }

    public TypeDefinition stringToTypeDefinition(@Nonnull String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return TypeDefinition.Invalid;
        }
        if ("DirectSpeakers".equals(type)) {
            return TypeDefinition.DirectSpeakers;
        }
        if ("Matrix".equals(type)) {
            return TypeDefinition.Matrix;
        }
        if ("Objects".equals(type)) {
            return TypeDefinition.Objects;
        }
        if ("HOA".equals(type)) {
            return TypeDefinition.HOA;
        }
        if ("Binaural".equals(type)) {
            return TypeDefinition.Binaural;
        }
        return TypeDefinition.Invalid;
    }

    public boolean isLegalTypeDefinition(@Nonnull String type) {
        return this.stringToTypeDefinition(type) != TypeDefinition.Invalid;
    }

    public TypeDefinition typeDefinition() {
        return this._definition;
    }

    public String label() {
        return this._label;
    }

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx) {
        if (!super.validate(ctx)) {
            return false;
        }
        boolean retVal = true;
        String id = this.id();
        if (this._definitionStr != null) {
            if (this._definition == TypeDefinition.Invalid) {
                ctx.addCheckAlert(MediaValidationCode.ADM_TYPEDEFINITION_INVALID, MediaUtil.dictionary.add("id", id).add("typedef", Strings.nullToEmpty((String)this._definitionStr)));
                retVal = false;
            }
        } else {
            ctx.addCheckAlert(MediaValidationCode.ADM_TYPEDEFINITION_MISSING, MediaUtil.dictionary.add("id", id));
            retVal = false;
        }
        if (this._label != null) {
            String typeVal = id.substring(3, 7);
            if (!this._label.equals(typeVal)) {
                ctx.addCheckAlert(MediaValidationCode.ADM_TYPELABEL_MISMATCH, MediaUtil.dictionary.add("id", id).add("typelabel", this._label));
                retVal = false;
            }
            if (!_validLabels.contains(this._label)) {
                ctx.addCheckAlert(MediaValidationCode.ADM_TYPELABEL_INVALID, MediaUtil.dictionary.add("id", id).add("typelabel", this._label));
                retVal = false;
            }
            if (this._definition == TypeDefinition.DirectSpeakers && !this._label.equals("0001") || this._definition == TypeDefinition.Matrix && !this._label.equals("0002") || this._definition == TypeDefinition.Objects && !this._label.equals("0003") || this._definition == TypeDefinition.HOA && !this._label.equals("0004") || this._definition == TypeDefinition.Binaural && !this._label.equals("0005")) {
                ctx.addCheckAlert(MediaValidationCode.ADM_TYPEDEFINITION_MISSMATCH, MediaUtil.dictionary.add("id", id).add("typedef", Strings.nullToEmpty((String)this._definitionStr)).add("typelabel", this._label));
                retVal = false;
            }
        } else {
            ctx.addCheckAlert(MediaValidationCode.ADM_TYPELABEL_MISSING, MediaUtil.dictionary.add("id", id));
            retVal = false;
        }
        return retVal;
    }

    static {
        _validLabels.add("0001");
        _validLabels.add("0002");
        _validLabels.add("0003");
        _validLabels.add("0004");
        _validLabels.add("0005");
    }

    public static enum TypeDefinition {
        Invalid,
        DirectSpeakers,
        Matrix,
        Objects,
        HOA,
        Binaural;

    }
}

