/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.ADM;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.audio.ADM.AudioObject;
import com.apple.jingle.leghorn.audio.ADM.ChannelFormat;
import com.apple.jingle.leghorn.audio.ADM.Content;
import com.apple.jingle.leghorn.audio.ADM.PackFormat;
import com.apple.jingle.leghorn.audio.ADM.StreamFormat;
import com.apple.jingle.leghorn.audio.ADM.TimeInterval;
import com.apple.jingle.leghorn.audio.ADM.TrackFormat;
import com.apple.jingle.leghorn.audio.ADM.TrackUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;

public class ADMData {
    private Map<String, Content> _contents = new HashMap<String, Content>();
    private Map<String, AudioObject> _audioObjects = new HashMap<String, AudioObject>();
    private Map<String, PackFormat> _packFormats = new HashMap<String, PackFormat>();
    private Map<String, ChannelFormat> _channelFormats = new HashMap<String, ChannelFormat>();
    private Map<String, TrackUID> _trackUIDs = new HashMap<String, TrackUID>();
    private Map<String, TrackFormat> _trackFormats = new HashMap<String, TrackFormat>();
    private Map<String, StreamFormat> _streamFormats = new HashMap<String, StreamFormat>();

    public void addContent(Content content) {
        this._contents.put(content.id(), content);
    }

    public void addAudioObject(AudioObject audioObject) {
        this._audioObjects.put(audioObject.id(), audioObject);
    }

    public int getAudioObjectCount() {
        return this._audioObjects.size();
    }

    public AudioObject getAudioObject(String id) {
        return this._audioObjects.get(id);
    }

    public Collection<AudioObject> getAllAudioObjects() {
        return this._audioObjects.values();
    }

    public Collection<String> getAllAudioObjectIds() {
        return this._audioObjects.keySet();
    }

    public void addPackFormat(PackFormat packFormat) {
        this._packFormats.put(packFormat.id(), packFormat);
    }

    public void addChannelFormat(ChannelFormat channelFormat) {
        this._channelFormats.put(channelFormat.id(), channelFormat);
    }

    public void addTrackUID(TrackUID trackUID) {
        this._trackUIDs.put(trackUID.UID(), trackUID);
    }

    public void addTrackFormat(TrackFormat trackFormat) {
        this._trackFormats.put(trackFormat.id(), trackFormat);
    }

    public void addStreamFormat(StreamFormat streamFormat) {
        this._streamFormats.put(streamFormat.id(), streamFormat);
    }

    public List<TimeInterval> getFlatenDurationIntervals() {
        Content mainContent = this._contents.values().iterator().next();
        ArrayList<TimeInterval> ret = new ArrayList<TimeInterval>();
        Comparator<TimeInterval> forwardTimeComparator = new Comparator<TimeInterval>(){

            @Override
            public int compare(TimeInterval o1, TimeInterval o2) {
                if (o1._start == o2._start) {
                    return 0;
                }
                if (o1._start < o2._start) {
                    return -1;
                }
                return 1;
            }
        };
        PriorityQueue<TimeInterval> minIntervalQueue = new PriorityQueue<TimeInterval>(50, forwardTimeComparator);
        for (AudioObject ao : mainContent.audioObjects()) {
            minIntervalQueue.add(ao.timeInterval());
        }
        while (!minIntervalQueue.isEmpty()) {
            TimeInterval cur = minIntervalQueue.poll();
            TimeInterval next = minIntervalQueue.peek();
            if (next == null || cur.end() < next._start) {
                ret.add(cur);
                continue;
            }
            long newStart = Math.min(cur._start, next._start);
            long newDuration = Math.max(cur.end(), next.end()) - newStart;
            TimeInterval merged = new TimeInterval(newStart, newDuration);
            minIntervalQueue.poll();
            minIntervalQueue.add(merged);
        }
        Collections.sort(ret, forwardTimeComparator);
        return ret;
    }

    private void resolvedObjectReferences(@Nonnull LeghornValidationContext ctx) {
        TrackFormat tf;
        PackFormat pf;
        for (Content c : this._contents.values()) {
            for (String aoid : c.audioObjectIDs()) {
                AudioObject ao = this._audioObjects.get(aoid);
                if (ao == null) continue;
                c.addAudioObject(ao);
            }
        }
        for (AudioObject ao : this._audioObjects.values()) {
            for (String pfid : ao.packFormatIDs()) {
                pf = this._packFormats.get(pfid);
                if (pf == null) continue;
                ao.addPackFormat(pf);
            }
            for (String tuid : ao.trackUIDs()) {
                TrackUID tid = this._trackUIDs.get(tuid);
                if (tid == null) continue;
                ao.addTrackUID(tid);
            }
            for (String aoid : ao.audioObjectIDs()) {
                AudioObject ao_child = this._audioObjects.get(aoid);
                if (ao_child == null) continue;
                ao.addAudioObject(ao_child);
            }
        }
        for (PackFormat pf2 : this._packFormats.values()) {
            for (String cid : pf2.channelFormatIDs()) {
                ChannelFormat cf = this._channelFormats.get(cid);
                if (cf == null) continue;
                pf2.addChannelFormat(cf);
            }
            for (String pfid : pf2.packFormatIDs()) {
                PackFormat pf_child = this._packFormats.get(pfid);
                if (pf_child == null) continue;
                pf2.addPackFormat(pf_child);
            }
        }
        for (TrackUID tuid : this._trackUIDs.values()) {
            for (String pfid : tuid.packFormatIDs()) {
                pf = this._packFormats.get(pfid);
                if (pf == null) continue;
                tuid.addPackFormat(pf);
            }
            for (String tfid : tuid.trackFormatIDs()) {
                tf = this._trackFormats.get(tfid);
                if (tf == null) continue;
                tuid.addTrackFormat(tf);
            }
        }
        for (TrackFormat tf2 : this._trackFormats.values()) {
            StreamFormat sf = this._streamFormats.get(tf2.streamFormatID());
            if (sf == null) continue;
            tf2.setStreamFormat(sf);
        }
        for (StreamFormat sf : this._streamFormats.values()) {
            PackFormat pf3;
            for (String tfid : sf.trackFormatIDs()) {
                tf = this._trackFormats.get(tfid);
                if (tf == null) continue;
                sf.addTrackFormat(tf);
            }
            ChannelFormat cf = this._channelFormats.get(sf.channelFormatID());
            if (cf != null) {
                sf.setChannelFormat(cf);
            }
            if ((pf3 = this._packFormats.get(sf.packFormatID())) == null) continue;
            sf.setPackFormat(pf3);
        }
    }

    public void postProcess(@Nonnull LeghornValidationContext ctx) {
        this.resolvedObjectReferences(ctx);
        for (Content content : this._contents.values()) {
            content.validate(ctx);
        }
        for (AudioObject audioObject : this._audioObjects.values()) {
            audioObject.validate(ctx);
        }
        for (PackFormat packFormat : this._packFormats.values()) {
            packFormat.validate(ctx);
        }
        for (ChannelFormat channelFormat : this._channelFormats.values()) {
            channelFormat.validate(ctx);
        }
        for (TrackFormat trackFormat : this._trackFormats.values()) {
            trackFormat.validate(ctx);
        }
        for (StreamFormat streamFormat : this._streamFormats.values()) {
            streamFormat.validate(ctx);
        }
        for (TrackUID trackUID : this._trackUIDs.values()) {
            trackUID.validate(ctx);
        }
    }
}

