/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.tools.VideoFrameExporter;
import java.io.File;
import org.apache.log4j.Logger;

public class VideoFrameExporterApplication {
    protected static final Logger LOG = Logger.getLogger(VideoFrameExporterApplication.class);

    public static void main(String[] args) throws Exception {
        String fileArgument = null;
        String destination = "/tmp/VideoFrameExport/";
        String fileNameTemplate = "img%07d.jpg";
        for (int i = 0; i < args.length; ++i) {
            if ("--destination".equals(args[i]) || "-d".equals(args[i])) {
                destination = args[++i];
                continue;
            }
            if ("--naming".equals(args[i]) || "-n".equals(args[i])) {
                fileNameTemplate = args[++i];
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                System.err.println("USAGE: exportframes [(-h|--help)] [(-d|--destination) output path] [(-n|--naming) filename format] inputfile ");
                System.exit(1);
                continue;
            }
            fileArgument = args[i];
        }
        if (fileArgument == null) {
            System.err.println("You must specify an input file.");
            System.exit(1);
        }
        File inputFile = new File(fileArgument);
        File destinationDir = new File(destination);
        if (destinationDir.mkdirs()) {
            LOG.info((Object)("Created directory " + destination + " to store exported frames in."));
        }
        VideoFrameExporter exporter = new VideoFrameExporter(inputFile, destinationDir, fileNameTemplate);
        exporter.export();
        System.out.println("Files exported to " + destination);
        System.out.println("Image Count: " + exporter.getImageCount());
        System.out.println("Frequency: " + exporter.getFrequencyInSeconds());
        System.out.println("Height: " + exporter.getHeight());
        System.out.println("Width: " + exporter.getWidth());
    }
}

