/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.atoms.DataReferenceAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class MegaDumpster
implements TreeSelectionListener {
    JTable propertiesTable;

    public static void main(String[] args) throws URIException, URISyntaxException {
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        try {
            new MegaDumpster(toDescribe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MegaDumpster(URI uri) throws IOException {
        JFrame megaDumpsterFrame = new JFrame();
        megaDumpsterFrame.setDefaultCloseOperation(3);
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(uri.getQuery());
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);){
            QuickTimeFile qtf = new QuickTimeParser().parseInput(ctx, sdi);
            JTree tree = new JTree(this.generateTreeNodes(qtf)){
                private static final long serialVersionUID = 5188253566030135072L;

                @Override
                public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)value;
                    Object o = dmtn.getUserObject();
                    if (o instanceof Atom) {
                        Atom a = (Atom)o;
                        return a.getAtomType();
                    }
                    if (o instanceof QuickTimeFile) {
                        QuickTimeFile qtf = (QuickTimeFile)o;
                        return qtf.toString();
                    }
                    if (o instanceof DataReferenceAtom.DataReference) {
                        DataReferenceAtom.DataReference dr = (DataReferenceAtom.DataReference)o;
                        return dr.getType();
                    }
                    return o.toString();
                }
            };
            this.expandAll(tree, true);
            tree.getSelectionModel().setSelectionMode(1);
            JScrollPane treeScrollPane = new JScrollPane(tree);
            this.propertiesTable = new JTable();
            JScrollPane propertiesTableScrollPane = new JScrollPane(this.propertiesTable);
            JSplitPane splitPane = new JSplitPane(1, treeScrollPane, propertiesTableScrollPane);
            megaDumpsterFrame.add(splitPane);
            tree.addTreeSelectionListener(this);
            megaDumpsterFrame.pack();
            megaDumpsterFrame.setVisible(true);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
        if (o instanceof QuickTimeFile) {
            this.propertiesTable.setModel(new DefaultTableModel());
        } else if (o instanceof Dumpsterable) {
            this.propertiesTable.setModel(new PropertyViewTableModel(((Dumpsterable)o).getProperties()));
        } else {
            throw new IllegalStateException("Clicked on object of type " + o.getClass());
        }
    }

    public DefaultMutableTreeNode generateTreeNodes(Object atom) {
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(atom);
        if (atom instanceof Container) {
            for (Object currentAtom : ((Container)atom).getChildren()) {
                currentNode.add(this.generateTreeNodes(currentAtom));
            }
        }
        return currentNode;
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public class PropertyViewTableModel
    implements TableModel {
        String[][] content;

        public PropertyViewTableModel(List<? extends Map.Entry<String, String>> properties) {
            Iterator<? extends Map.Entry<String, String>> it = properties.iterator();
            this.content = new String[properties.size()][2];
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                this.content[i++] = new String[]{e.getKey(), e.getValue()};
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IllegalStateException("Tried to getColumnName for value " + columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.content.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.content[rowIndex][0];
                }
                case 1: {
                    return this.content[rowIndex][1];
                }
            }
            throw new IllegalStateException("Tried to getValueAt for value " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }
}

