/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.util.SimpleArgParse;
import com.apple.jingle.leghorn.util.UnicodeUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class MapCJKVerticalCharsApplication {
    public static final String TOOL_NAME = "convertSubtitles";
    public static final String TOOL_VERSION = "1.0";
    private static final String TOOL_USAGE = "convertSubtitles 1.0\nUSAGE: MapCJKVerticalCharsApplication <input file path> <output file path> [<mapping override file>]\n      Mapping file should be a text file with multiple lines. Each line should be of the form 0xNNNN = 0xMMMM to indicate NNNN should be mapped to MMMM.\n# Example mapping override file\n\n# Use http://inamidst.com/stuff/unidata/ to find codepoints\n# Example entry to disable mapping of '0' character\n0030 = 0030";

    private static SimpleArgParse parseCommandLine(String[] args) throws IllegalArgumentException {
        SimpleArgParse parser = new SimpleArgParse();
        parser.addArgument("input", "i").addArgument("output", "o").addArgument("override", "m", false, "").parse(args);
        return parser;
    }

    public static void main(String[] args) {
        SimpleArgParse parser = null;
        try {
            parser = MapCJKVerticalCharsApplication.parseCommandLine(args);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        MapCJKVerticalCharsApplication.mainWithArguments(parser);
    }

    private static void mainWithArguments(SimpleArgParse args) {
        String outputFilename;
        String inputFilename = args.getArgumentValue("input");
        if (Strings.isNullOrEmpty((String)inputFilename)) {
            System.err.println("ERROR: Input filename is required.");
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        if (Strings.isNullOrEmpty((String)(outputFilename = args.getArgumentValue("output")))) {
            System.err.println("ERROR: Input filename is required.");
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        String overrideFilename = args.getArgumentValue("override");
        System.out.printf("Input: %s\nOutput: %s\nOverride: [%s]%n", inputFilename, outputFilename, overrideFilename);
        UnicodeUtil.CJKCompatibility cjkUtil = new UnicodeUtil.CJKCompatibility();
        if (!Strings.isNullOrEmpty((String)overrideFilename)) {
            cjkUtil.setOverrideMap(overrideFilename);
        }
        try {
            String input = FileUtils.readFileToString((File)new File(inputFilename));
            FileUtils.writeStringToFile((File)new File(outputFilename), (String)cjkUtil.halfToFullWidth(input));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
    }

    static {
        Logger.getRootLogger().setLevel(Level.ERROR);
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), "System.err"));
    }
}

