/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.locale.LocaleCode;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ListStreamsApplication {
    public static void main(String[] args) throws URISyntaxException, URIException {
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        try {
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            Verifier verifier = Verifier.getDefaultVerifier();
            ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe);
            ContainerDescription description = verifier.describe(toDescribe, containerType);
            for (String streamId : description.getStreamIdentifiers()) {
                System.out.println("Stream " + streamId + ":");
                FormatDescription formatDescription = description.getStreamFormatDescription(streamId);
                if (formatDescription == null) {
                    System.out.println("\tMissing Format Description");
                    continue;
                }
                System.out.println("\tType: " + formatDescription.getType().getName());
                LocaleCode language = formatDescription.getLanguage();
                if (language == null) continue;
                System.out.println("\tLanguage: " + language);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

