/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.StreamLocation;
import com.apple.jingle.locale.LocaleCode;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class ListFeaturesApplication {
    private static final Pattern FEATURE_PATTERN = Pattern.compile("^Feature\\.(.*)$");
    private static final Predicate featurePredicate = new Predicate(){

        public boolean evaluate(Object arg0) {
            if (arg0 instanceof String) {
                return ((String)arg0).startsWith("Feature.");
            }
            throw new RuntimeException("Cannot filter object that is not instance of String: " + arg0);
        }
    };

    public static void main(String[] args) throws URIException, URISyntaxException {
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        try {
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            Verifier verifier = Verifier.getDefaultVerifier();
            ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe);
            ContainerDescription description = verifier.describe(toDescribe, containerType);
            Node descriptionDocument = (Node)description.getDescriptionDocument();
            HashSet<String> featureConformanceNames = new HashSet<String>(containerType.getConformanceProfileNames());
            CollectionUtils.filter(featureConformanceNames, (Predicate)featurePredicate);
            for (String featureConformanceName : featureConformanceNames) {
                ConformanceResultGatherer crg;
                if (!Verifier.verifyConformance(descriptionDocument, containerType, featureConformanceName, crg = new ConformanceResultGatherer())) continue;
                HashSet affectedStreamIds = Sets.newHashSet();
                for (AssertionExplanation assertionExplanation : crg.getSuccesses()) {
                    for (StreamLocation location : assertionExplanation.getLocations()) {
                        affectedStreamIds.add(location.getStreamId());
                    }
                }
                Matcher matcher = FEATURE_PATTERN.matcher(featureConformanceName);
                if (!matcher.matches()) {
                    throw new RuntimeException("Uh oh, conformance \"" + featureConformanceName + "\" looked like a feature conformance but doesn't match our regex." + "  This should never happen.");
                }
                String featureName = matcher.group(1);
                HashMap languageToStreams = new HashMap();
                for (String streamIdentifier : affectedStreamIds) {
                    FormatDescription formatDescription = description.getStreamFormatDescription(streamIdentifier);
                    if (formatDescription.getLanguage() != null) {
                        if (!languageToStreams.containsKey(formatDescription.getLanguage())) {
                            languageToStreams.put(formatDescription.getLanguage(), new LinkedList());
                        }
                        ((List)languageToStreams.get(formatDescription.getLanguage())).add(streamIdentifier);
                        continue;
                    }
                    if (!languageToStreams.containsKey(null)) {
                        languageToStreams.put(null, new LinkedList());
                    }
                    ((List)languageToStreams.get(null)).add(streamIdentifier);
                }
                for (LocaleCode locale : languageToStreams.keySet()) {
                    if (locale != null) {
                        System.out.printf("%s (%s):\n", featureName, locale.toString());
                    } else {
                        System.out.printf("%s:\n", featureName);
                    }
                    for (String affectedStreamId : (List)languageToStreams.get(locale)) {
                        System.out.printf("\tStream %s\n", affectedStreamId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

