/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import java.net.URI;

public class LeghornApplicationUtils {
    public static Verifier getVerifier(String environment) throws VerifierBuilder.UnableToBuildVerifierException {
        Verifier verifier = null;
        try {
            if (environment != null) {
                verifier = Verifier.getVerifier(environment);
            }
        }
        catch (VerifierBuilder.UnableToBuildVerifierException utbve) {
            throw new IllegalArgumentException(String.format("Could not build verifier for the environment (%s) you specified.", environment));
        }
        if (verifier == null) {
            verifier = Verifier.getDefaultVerifier();
        }
        return verifier;
    }

    public static ContainerType getContainerType(Verifier verifier, URI toDescribe, String roleToUse, String utiToUse, String mimeToUse) throws UnknownTypeException {
        ContainerType containerType;
        if (utiToUse != null) {
            containerType = verifier.getContainerTypeFactory().getTypeForUTI(utiToUse);
        } else if (mimeToUse != null) {
            containerType = verifier.getContainerTypeFactory().getTypeForMimeType(mimeToUse);
        } else {
            String extension = toDescribe.getPath().lastIndexOf(".") == -1 ? "?" : toDescribe.getPath().substring(toDescribe.getPath().lastIndexOf("."));
            try {
                containerType = verifier.getContainerTypeFactory().getTypeForExtension(extension);
            }
            catch (UnknownTypeException ute) {
                if (roleToUse == null) {
                    throw ute;
                }
                containerType = verifier.getContainerTypeFactory().getTypeForExtension(roleToUse + extension);
            }
        }
        return containerType;
    }

    public static ContainerType getContainerType(Verifier verifier, URI toDescribe) throws UnknownTypeException {
        String roleToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.roleToUse");
        String utiToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.utiToUse");
        String mimeToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.mimeToUse");
        return LeghornApplicationUtils.getContainerType(verifier, toDescribe, roleToUse, utiToUse, mimeToUse);
    }
}

