/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.XML;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdrMetadataSlicer {
    private long rawSliceStartFrameNumber;
    private long rawSliceEndFrameNumber;
    @Nullable
    private MediaTime rawSliceStartTime;
    @Nullable
    private MediaTime rawSliceEndTime;
    private final HdrMetadataSlicerType instantiationType;

    private HdrMetadataSlicer(long rawSliceStartFrameNumber, long rawSliceEndFrameNumber) {
        this.rawSliceStartFrameNumber = rawSliceStartFrameNumber < 0L ? 0L : rawSliceStartFrameNumber;
        this.rawSliceEndFrameNumber = rawSliceEndFrameNumber < 0L ? Long.MAX_VALUE : rawSliceEndFrameNumber;
        this.instantiationType = HdrMetadataSlicerType.FrameNumberBased;
    }

    private HdrMetadataSlicer(@Nullable MediaTime rawSliceStartTime, @Nullable MediaTime rawSliceEndTime) {
        this.rawSliceStartTime = rawSliceStartTime;
        this.rawSliceEndTime = rawSliceEndTime;
        this.instantiationType = HdrMetadataSlicerType.MediaTimeBased;
    }

    @Nonnull
    public static HdrMetadataSlicer getFrameNumberBasedHdrMetadataSlicer(long rawSliceStartFrmaeNumber, long rawSliceEndFrameNumber) {
        return new HdrMetadataSlicer(rawSliceStartFrmaeNumber, rawSliceEndFrameNumber);
    }

    @Nonnull
    public static HdrMetadataSlicer getMediaTimeBasedHdrMetadataSlicer(@Nullable MediaTime rawSliceStartTime, @Nullable MediaTime rawSliceEndTime) {
        return new HdrMetadataSlicer(rawSliceStartTime, rawSliceEndTime);
    }

    public void slice(@Nonnull Reader in, @Nonnull PrintWriter out) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        HdrMetadataHandler handler = new HdrMetadataHandler(out);
        parser.parse(new InputSource(in), (DefaultHandler)handler);
    }

    @Nullable
    private static CommandLine processCommandLineArgs(String[] args) {
        Options options = new Options();
        Option input = new Option("i", "inputFile", true, "input hdr metadata file");
        input.setRequired(true);
        options.addOption(input);
        Option outputFile = new Option("o", "outputFile", true, "output cut hdr metadata file");
        outputFile.setRequired(true);
        options.addOption(outputFile);
        Option startFrame = new Option("sf", "startFrame", true, "start frame number for cut [optional]");
        startFrame.setRequired(false);
        options.addOption(startFrame);
        Option endFrame = new Option("ef", "endFrame", true, "end frame number for cut [optional]");
        endFrame.setRequired(false);
        options.addOption(endFrame);
        Option startTime = new Option("st", "startTime", true, "start time cut (in milliseconds) [optional]");
        startTime.setRequired(false);
        options.addOption(startTime);
        Option endTime = new Option("et", "endTime", true, "end time cut (in milliseconds) [optional]");
        endTime.setRequired(false);
        options.addOption(endTime);
        Option startSampleCount = new Option("sc", "startSampleCount", true, "start sample count [optional]");
        startSampleCount.setRequired(false);
        options.addOption(startSampleCount);
        Option endSampleCount = new Option("ec", "endSampleCount", true, "end sample count [optional]");
        endSampleCount.setRequired(false);
        options.addOption(endSampleCount);
        Option sampleRate = new Option("sr", "sampleRate", true, "sample rate [optional]");
        sampleRate.setRequired(false);
        options.addOption(sampleRate);
        BasicParser parser = new BasicParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("HdrMetadataSlicer", options);
            System.out.println("\nExamples:");
            System.out.println("\t1. No Cut:\n\t\t HdrMetadataSlicer -i hdr_metadata_file.xml -o hdr_metadata_cut_file.xml");
            System.out.println("\t2. Cut Frame Range [1000 - 10000]:\n\t\t HdrMetadataSlicer -i hdr_metadata_file.xml -o hdr_metadata_cut_file.xml -sf 1000 -ef 10000");
            System.out.println("\t3. Cut Time Range [60000 - 600000 milliseconds]:\n\t\t HdrMetadataSlicer -i hdr_metadata_file.xml -o hdr_metadata_cut_file.xml -st 60000 -et 600000");
            System.out.println("\t3. Cut Time Range [14064 24/999:1000 - 16944 24/999:1000]:\n\t\t HdrMetadataSlicer -i hdr_metadata_file.xml -o hdr_metadata_cut_file.xml -sc 14064 -ec 16944 -sr 24/999:1000");
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine commandLine = HdrMetadataSlicer.processCommandLineArgs(args);
            File inFile = new File(commandLine.getOptionValue("inputFile"));
            File outFile = new File(commandLine.getOptionValue("outputFile"));
            try (FileReader r = new FileReader(inFile);
                 PrintWriter w = new PrintWriter(new FileWriter(outFile, false));){
                if (commandLine.hasOption("startFrame") && commandLine.hasOption("endFrame")) {
                    Long startFrame = Long.valueOf(commandLine.getOptionValue("startFrame"));
                    Long endFrame = Long.valueOf(commandLine.getOptionValue("endFrame"));
                    System.out.println("\nCut Range Frames [" + startFrame + " - " + endFrame + "]");
                    HdrMetadataSlicer.getFrameNumberBasedHdrMetadataSlicer(startFrame, endFrame).slice(r, w);
                } else if (commandLine.hasOption("startTime") && commandLine.hasOption("endTime")) {
                    Long startTime = Long.valueOf(commandLine.getOptionValue("startTime"));
                    Long endTime = Long.valueOf(commandLine.getOptionValue("endTime"));
                    System.out.println("\nCut Range Time (in milliseconds) [" + startTime + " - " + endTime + "]");
                    HdrMetadataSlicer.getMediaTimeBasedHdrMetadataSlicer(new MediaTime((long)startTime, 1000L), new MediaTime((long)endTime, 1000L)).slice(r, w);
                } else if (commandLine.hasOption("startSampleCount") && commandLine.hasOption("endSampleCount") && commandLine.hasOption("sampleRate")) {
                    Long startSampleCount = Long.valueOf(commandLine.getOptionValue("startSampleCount"));
                    Long endSampleCount = Long.valueOf(commandLine.getOptionValue("endSampleCount"));
                    String sampleRateStr = commandLine.getOptionValue("sampleRate");
                    SampleRate sampleRate = SampleRate.parseSampleRateString(sampleRateStr);
                    HdrMetadataSlicer.getMediaTimeBasedHdrMetadataSlicer(new MediaTime((long)startSampleCount, sampleRate), new MediaTime((long)endSampleCount, sampleRate)).slice(r, w);
                } else {
                    System.out.println("\nNo Cut being performed");
                    HdrMetadataSlicer.getMediaTimeBasedHdrMetadataSlicer(null, null).slice(r, w);
                }
            }
            System.out.println("\nHDR Metadata Input File: " + inFile.getAbsolutePath());
            System.out.println("Cut HDR Metadata Output File: " + outFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class HdrMetadataHandler
    extends DefaultHandler {
        @Nonnull
        private final PrintWriter out;
        @Nonnull
        private final LinkedList<Pair<String, String>> prefixMap = new LinkedList();
        private HdrMetadataElement lastElement = null;
        private HdrMetadataShotElement shotElement = null;
        private long uniqueIdOffset = -1L;
        private long frameNumber = -1L;
        private Double frameRate;
        private Double frameRateN;
        private Double frameRateD;
        private boolean insideShotElement = false;

        private HdrMetadataHandler(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            if (locator.getPublicId() == null && locator.getSystemId() == null) {
                this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            this.out.write("\n");
            this.uniqueIdOffset = -1L;
            this.frameNumber = 0L;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.prefixMap.add((Pair<String, String>)Pair.of((Object)prefix, (Object)uri));
            super.startPrefixMapping(prefix, uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (HdrMetadataTag.Shot.getElementTagName().equalsIgnoreCase(localName)) {
                this.insideShotElement = true;
            }
            AttributeMap attrMap = new AttributeMap(attributes);
            if (this.insideShotElement) {
                if (this.shotElement == null) {
                    this.shotElement = new HdrMetadataShotElement(null, uri, localName, qName, attrMap);
                } else {
                    this.shotElement.addChild(uri, localName, qName, attrMap);
                }
            } else {
                this.lastElement = this.lastElement != null ? this.lastElement.openChild(uri, localName, qName, attrMap) : new HdrMetadataElement(null, uri, localName, qName, attrMap, true);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (HdrMetadataTag.Shot.getElementTagName().equalsIgnoreCase(localName) && this.insideShotElement) {
                this.insideShotElement = false;
                this.shotElement.close();
                this.shotElement = null;
            } else if (this.insideShotElement) {
                this.shotElement.closeChild();
            } else if (this.lastElement != null) {
                this.lastElement = this.lastElement.close();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String data = new String(ch, start, length);
            if (this.insideShotElement) {
                this.shotElement.appendText(data);
            } else if (this.lastElement != null) {
                this.lastElement.appendText(data);
            } else {
                this.out.write(XML.escape((String)data));
            }
            super.characters(ch, start, length);
        }

        private class HdrMetadataShotElement
        extends HdrMetadataElement {
            private static final String HDR_ELEMENT_REGEX_PATTERN = "(\\s|\\n|\\r)*";
            private final StringBuilder writeBuffer;
            private HdrMetadataElement lastElement;
            private HdrMetadataTag hdrMetadataTag;
            private long frameNumber;
            private long duration;
            private long uniqueId;

            HdrMetadataShotElement(HdrMetadataElement parent, String uri, String localName, String qName, AttributeMap attributes) {
                super(parent, uri, localName, qName, attributes, false);
                this.writeBuffer = new StringBuilder();
                this.lastElement = null;
                this.writeBuffer.append(this.writeStartElement());
                this.writeBuffer.append(">");
            }

            void addChild(String uri, String localName, String qName, AttributeMap attributes) {
                this.lastElement = this.lastElement == null ? new HdrMetadataElement(this, uri, localName, qName, attributes, false) : new HdrMetadataElement(this.lastElement, uri, localName, qName, attributes, false);
                this.hdrMetadataTag = HdrMetadataTag.getHdrMetadataTagForElementTagName(localName, this.lastElement.parent.localName);
                this.writeBuffer.append(this.lastElement.writeStartElement());
            }

            void closeChild() {
                this.writeBuffer.append(this.lastElement.writeEndElement());
                this.lastElement = this.lastElement.parent;
            }

            @Override
            public void appendText(@Nonnull String str) {
                String strVal = str.trim();
                if (this.hdrMetadataTag != null && this.validShotElementValueString(strVal)) {
                    this.processHdrMetadataShotElementValue(strVal);
                }
                if (this.lastElement != null && this.lastElement != this) {
                    this.writeBuffer.append(this.lastElement.writeAppendText(str));
                } else {
                    this.writeBuffer.append(XML.escape((String)str));
                }
            }

            private void processHdrMetadataShotElementValue(@Nonnull String strVal) {
                switch (this.hdrMetadataTag) {
                    case ShotUniqueID: {
                        if (HdrMetadataHandler.this.uniqueIdOffset == -1L) {
                            HdrMetadataHandler.this.uniqueIdOffset = Long.valueOf(strVal);
                        }
                        this.uniqueId = Long.valueOf(strVal);
                        break;
                    }
                    case ShotRecordIn: {
                        this.frameNumber = Long.valueOf(strVal);
                        break;
                    }
                    case ShotRecordDuration: {
                        this.duration = Long.valueOf(strVal);
                    }
                }
            }

            @Override
            public HdrMetadataElement close() {
                this.writeBuffer.append("</");
                this.writeBuffer.append(XML.escape((String)this.qName));
                this.writeBuffer.append('>');
                if (this.withinCutRange()) {
                    HdrMetadataHandler.this.out.write(this.adjustHdrMetadataShotElementsForCut());
                }
                return this.parent;
            }

            @Nonnull
            private String adjustHdrMetadataShotElementsForCut() {
                long newDuration;
                long newFrameNumber;
                if (HdrMetadataHandler.this.frameNumber == -1L) {
                    newFrameNumber = 0L;
                    newDuration = this.frameNumber + this.duration - HdrMetadataSlicer.this.rawSliceStartFrameNumber;
                } else {
                    newFrameNumber = HdrMetadataHandler.this.frameNumber;
                    newDuration = this.frameNumber + this.duration > HdrMetadataSlicer.this.rawSliceEndFrameNumber ? HdrMetadataSlicer.this.rawSliceEndFrameNumber - this.frameNumber : this.duration;
                }
                HdrMetadataHandler.this.frameNumber = newFrameNumber + newDuration;
                if (newDuration != 0L) {
                    return this.writeBuffer.toString().replaceAll(HdrMetadataTag.ShotRecordIn.getElementStartXmlTag() + HDR_ELEMENT_REGEX_PATTERN + this.frameNumber + HDR_ELEMENT_REGEX_PATTERN + HdrMetadataTag.ShotRecordIn.getElementEndXmlTag(), HdrMetadataTag.ShotRecordIn.getElementStartXmlTag() + newFrameNumber + HdrMetadataTag.ShotRecordIn.getElementEndXmlTag()).replaceAll(HdrMetadataTag.ShotRecordDuration.getElementStartXmlTag() + HDR_ELEMENT_REGEX_PATTERN + this.duration + HDR_ELEMENT_REGEX_PATTERN + HdrMetadataTag.ShotRecordDuration.getElementEndXmlTag(), HdrMetadataTag.ShotRecordDuration.getElementStartXmlTag() + newDuration + HdrMetadataTag.ShotRecordDuration.getElementEndXmlTag());
                }
                return "";
            }

            private boolean withinCutRange() {
                return this.frameNumber + this.duration >= HdrMetadataSlicer.this.rawSliceStartFrameNumber && this.frameNumber <= HdrMetadataSlicer.this.rawSliceEndFrameNumber;
            }
        }

        private class HdrMetadataElement {
            @Nullable
            final HdrMetadataElement parent;
            boolean openElementCompleted = false;
            final String qName;
            final String localName;
            final boolean writeRequired;
            private final AttributeMap attributes;
            private HdrMetadataTag hdrMetadataTag;

            HdrMetadataElement(HdrMetadataElement parent, String uri, String localName, String qName, AttributeMap attributes, boolean writeRequired) {
                this.parent = parent;
                this.qName = qName;
                this.localName = localName;
                this.attributes = attributes;
                this.writeRequired = writeRequired;
                this.hdrMetadataTag = HdrMetadataTag.getHdrMetadataTagForElementTagName(localName, parent != null ? parent.localName : null);
                if (this.writeRequired) {
                    HdrMetadataHandler.this.out.write(this.writeStartElement());
                }
            }

            public HdrMetadataElement close() {
                if (this.writeRequired) {
                    HdrMetadataHandler.this.out.write(this.writeEndElement());
                }
                return this.parent;
            }

            HdrMetadataElement openChild(String uri, String localName, String qName, AttributeMap attributes) {
                if (this.writeRequired && !this.openElementCompleted) {
                    HdrMetadataHandler.this.out.write(">");
                    this.openElementCompleted = true;
                }
                return new HdrMetadataElement(this, uri, localName, qName, attributes, true);
            }

            public void appendText(@Nonnull String str) {
                String strVal = str.trim();
                if (this.hdrMetadataTag != null && this.validShotElementValueString(strVal)) {
                    this.processHdrMetadataElementValue(strVal);
                }
                if (HdrMetadataHandler.this.frameRate == null && HdrMetadataHandler.this.frameRateN != null && HdrMetadataHandler.this.frameRateD != null) {
                    this.computeCutRangeDetails();
                }
                if (this.writeRequired) {
                    HdrMetadataHandler.this.out.write(this.writeAppendText(str));
                }
            }

            private void computeCutRangeDetails() {
                HdrMetadataHandler.this.frameRate = new BigDecimal(HdrMetadataHandler.this.frameRateN / HdrMetadataHandler.this.frameRateD).setScale(4, RoundingMode.FLOOR).doubleValue();
                if (HdrMetadataSlicer.this.instantiationType == HdrMetadataSlicerType.MediaTimeBased) {
                    HdrMetadataSlicer.this.rawSliceStartFrameNumber = HdrMetadataSlicer.this.rawSliceStartTime != null ? new Double(HdrMetadataSlicer.this.rawSliceStartTime.getSeconds() * HdrMetadataHandler.this.frameRate).longValue() : 0L;
                    HdrMetadataSlicer.this.rawSliceEndFrameNumber = HdrMetadataSlicer.this.rawSliceEndTime != null ? new Double(HdrMetadataSlicer.this.rawSliceEndTime.getSeconds() * HdrMetadataHandler.this.frameRate).longValue() : Long.MAX_VALUE;
                }
            }

            private void processHdrMetadataElementValue(@Nonnull String strVal) {
                switch (this.hdrMetadataTag) {
                    case RateNumerator: {
                        if (HdrMetadataHandler.this.frameRateN != null) break;
                        HdrMetadataHandler.this.frameRateN = Double.valueOf(strVal);
                        break;
                    }
                    case RateDenominator: {
                        if (HdrMetadataHandler.this.frameRateD != null) break;
                        HdrMetadataHandler.this.frameRateD = Double.valueOf(strVal);
                    }
                }
            }

            @Nonnull
            String writeStartElement() {
                StringBuilder writeBuffer = new StringBuilder();
                writeBuffer.append('<');
                writeBuffer.append(XML.escape((String)this.qName));
                for (Pair entry : HdrMetadataHandler.this.prefixMap) {
                    String prefix = (String)entry.getKey();
                    String prefixUri = (String)entry.getValue();
                    if (prefix != null && prefix.length() > 0) {
                        writeBuffer.append(" xmlns:");
                        writeBuffer.append(XML.escape((String)prefix));
                        writeBuffer.append("=\"");
                        writeBuffer.append(XML.escape((String)prefixUri));
                        writeBuffer.append('\"');
                        continue;
                    }
                    writeBuffer.append(" xmlns=\"");
                    writeBuffer.append(XML.escape((String)prefixUri));
                    writeBuffer.append('\"');
                }
                HdrMetadataHandler.this.prefixMap.clear();
                for (Attribute attr : this.attributes) {
                    if (attr.value != null) {
                        writeBuffer.append(' ');
                        writeBuffer.append(XML.escape((String)attr.qkey));
                        writeBuffer.append("=\"");
                        writeBuffer.append(XML.escape((String)attr.value));
                        writeBuffer.append('\"');
                        continue;
                    }
                    writeBuffer.append(' ');
                    writeBuffer.append(XML.escape((String)attr.qkey));
                }
                return writeBuffer.toString();
            }

            @Nonnull
            String writeEndElement() {
                StringBuilder writeBuffer = new StringBuilder();
                if (!this.openElementCompleted) {
                    this.openElementCompleted = true;
                    writeBuffer.append("/>");
                } else {
                    writeBuffer.append("</");
                    writeBuffer.append(XML.escape((String)this.qName));
                    writeBuffer.append('>');
                }
                return writeBuffer.toString();
            }

            @Nonnull
            String writeAppendText(@Nonnull String str) {
                StringBuilder writeBuffer = new StringBuilder();
                if (!this.openElementCompleted) {
                    writeBuffer.append(">");
                    this.openElementCompleted = true;
                }
                writeBuffer.append(XML.escape((String)str));
                return writeBuffer.toString();
            }

            boolean validShotElementValueString(@Nonnull String strVal) {
                return !strVal.equalsIgnoreCase(System.getProperty("line.separator")) && !StringUtils.isEmpty((CharSequence)strVal);
            }
        }
    }

    private static class Attribute {
        final Pair<String, String> qname;
        final String qkey;
        private String value;

        public Attribute(Attributes attributes, int idx) {
            this.qname = Pair.of((Object)attributes.getURI(idx), (Object)attributes.getLocalName(idx));
            this.qkey = attributes.getQName(idx);
            this.value = attributes.getValue(idx);
        }
    }

    static class AttributeMap
    implements Iterable<Attribute> {
        private ArrayList<Attribute> values;
        private HashMap<Object, Attribute> map = new HashMap();

        AttributeMap(Attributes attributes) {
            this.values = new ArrayList(attributes.getLength());
            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                Attribute attr = new Attribute(attributes, idx);
                this.values.add(attr);
                this.map.put(attr.qname, attr);
                this.map.put(attr.qname.getRight(), attr);
            }
        }

        @Nonnull
        Attribute getAttribute(@Nonnull String localName) {
            Attribute attr = this.tryAttribute(localName);
            if (attr != null) {
                return attr;
            }
            throw new NoSuchElementException(localName);
        }

        @Nullable
        Attribute tryAttribute(@Nonnull String localName) {
            return this.map.get(localName);
        }

        @Nullable
        String tryValue(@Nonnull String localName) {
            Attribute attr = this.tryAttribute(localName);
            if (attr != null) {
                return attr.value;
            }
            return null;
        }

        @Nullable
        String tryValue(@Nonnull String uri, @Nonnull String localName) {
            Attribute attr = this.map.get(Pair.of((Object)uri, (Object)localName));
            if (attr != null) {
                return attr.value;
            }
            return null;
        }

        @Override
        public Iterator<Attribute> iterator() {
            return this.values.iterator();
        }
    }

    private static enum HdrMetadataTag {
        RateNumerator("n", "Rate"),
        RateDenominator("d", "Rate"),
        Shot("Shot", "Track"),
        ShotUniqueID("UniqueID", "Shot"),
        ShotRecordIn("In", "Record"),
        ShotRecordDuration("Duration", "Record"),
        Other(null, null);

        private final String elementTagName;
        private final String parentElementTagName;

        private HdrMetadataTag(String elementTagName, String parentElementTagName) {
            this.elementTagName = elementTagName;
            this.parentElementTagName = parentElementTagName;
        }

        @Nullable
        public String getElementTagName() {
            return this.elementTagName;
        }

        @Nullable
        public String getElementStartXmlTag() {
            return "<" + this.elementTagName + ">";
        }

        @Nullable
        public String getElementEndXmlTag() {
            return "</" + this.elementTagName + ">";
        }

        @Nonnull
        public static HdrMetadataTag getHdrMetadataTagForElementTagName(@Nullable String elementTagName, @Nullable String parentElementTagName) {
            if (elementTagName != null) {
                for (HdrMetadataTag hdrMetadataTag : HdrMetadataTag.values()) {
                    if (!elementTagName.equalsIgnoreCase(hdrMetadataTag.elementTagName) || parentElementTagName != null && !parentElementTagName.equalsIgnoreCase(hdrMetadataTag.parentElementTagName)) continue;
                    return hdrMetadataTag;
                }
            }
            return Other;
        }
    }

    private static enum HdrMetadataSlicerType {
        FrameNumberBased,
        MediaTimeBased;

    }
}

