/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FileDescriber;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class DescribeApplication
implements FileDescriber<Node> {
    public ContainerDescription<Node> describeFile(URI toDescribe, String roleToUse, String utiToUse, String mimeToUse, String environment) throws Exception {
        Verifier verifier = LeghornApplicationUtils.getVerifier(environment);
        ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe, roleToUse, utiToUse, mimeToUse);
        return verifier.describe(toDescribe, containerType);
    }

    public ContainerDescription<Node> describeFile(URI toDescribe) throws Exception {
        String roleToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.roleToUse");
        String utiToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.utiToUse");
        String mimeToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.mimeToUse");
        String environmentToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.environment");
        return this.describeFile(toDescribe, roleToUse, utiToUse, mimeToUse, environmentToUse);
    }

    @Override
    public ContainerDescription<Node> describeFile(File toDescribe) throws Exception {
        return this.describeFile(toDescribe.toURI());
    }

    public static void main(String[] args) throws Exception {
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        DescribeApplication describeApplication = new DescribeApplication();
        try {
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            Node descriptionNode = describeApplication.describeFile(toDescribe).getDescriptionDocument();
            String descriptionString = XMLUtil.nodeToString((Node)descriptionNode);
            PrintStream ps = null;
            try {
                ps = new PrintStream((OutputStream)System.out, true, "UTF-8");
            }
            catch (UnsupportedEncodingException error) {
                System.err.println(error);
                System.exit(0);
            }
            ps.print(descriptionString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

