/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.applications.DescribeApplication;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationLevelCalculator;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.quicktime.ITTValidationContext;
import com.apple.jingle.leghorn.subtitle.webvtt.ReadableAsset;
import com.apple.jingle.leghorn.subtitle.webvtt.SubtitleConvertException;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTStyleParser;
import com.apple.jingle.leghorn.subtitle.webvtt.WebVTTExporter;
import com.apple.jingle.leghorn.subtitle.webvtt.ittImporterXMLBeans;
import com.apple.jingle.leghorn.subtitle.webvtt.texmlExporter;
import com.apple.jingle.leghorn.util.SimpleArgParse;
import com.apple.jingle.leghorn.util.TTMLSchemaValidationHelper;
import com.apple.jingle.media.foundation.util.XMLUtil;
import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Node;

public class ConvertSubtitlesApplication {
    private static final Logger logger = Logger.getLogger(ConvertSubtitlesApplication.class);
    public static final String TOOL_NAME = "convertSubtitles";
    public static final String TOOL_VERSION = "1.0";
    private static final String TOOL_USAGE = "USAGE: ConvertSubtitlesApplication <input file path>.itt <output file path>.{vtt|texml} [output_dimensions for texml (for example 1920x1080)]";
    private static final String FMT_ITT2WEBVTT_INFO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<itt2webvtt_info xmlns=\"http://jingle.apple.com/itunes_timed_text/itt2webvtt_info\">\n%s\n%s\n%s\n</itt2webvtt_info>";
    private static final String FMT_TOOL_INFO = "<tool_info><tool_name>%s</tool_name><tool_version>%s</tool_version></tool_info>";
    private static final String FMT_ITT2WEBVTT = "<itt2webvtt>\n\t<itt_file_path>%s</itt_file_path>\n\t<itt_file_description>%s</itt_file_description>\n\t<webvtt_file_path>%s</webvtt_file_path>\n\t%s\n\t%s\n</itt2webvtt>";
    private static final String FMT_ITT_DESCRIPTION_IN_CASE_OF_EXCEPTION = "<subtitle_description fileSize=\"%d\" xmlns=\"http://jingle.apple.com/leghorn/subtitle/xml\"><language>en-EN</language><subtitleDiagnostics><diagnostic><message>%s</message></diagnostic></subtitleDiagnostics></subtitle_description>";
    private static final String FMT_VTT_DESCRIPTION_IN_CASE_OF_EXCEPTION = "<vtt_description fileSize=\"%d\"><headerMessage>Generated by WebVTTExporter v.0.5</headerMessage><vttDiagnostics><vttDiagnostic><message>%s</message></vttDiagnostic></vttDiagnostics></vtt_description>";
    private static final String FMT_ALERT_LIST = "<alerts>%s</alerts>";
    private static final String FMT_ALERT = "<alert level=\"%s\" code=\"%s\"><description>%s</description>%s</alert>";
    private static final String FMT_ALERT_INFO_LIST = "<alert_info>%s</alert_info>";
    private static final String FMT_ALERT_INFO_LIST_ENTRY = "<entry key=\"%03d\">%s</entry>";
    private DescribeApplication describeApplication = new DescribeApplication();
    private String _inputFilename;
    private String _outputFilename;

    @Nonnull
    private String getItt2WebVttInfoString(@Nullable String alertList, String ... itt2webvttInfos) {
        StringBuilder concatenated_itt2webvtt = new StringBuilder("");
        if (null != itt2webvttInfos) {
            for (String conversion : itt2webvttInfos) {
                concatenated_itt2webvtt.append(conversion);
            }
        }
        return String.format(FMT_ITT2WEBVTT_INFO, this.getToolInfo(), concatenated_itt2webvtt.toString(), null != alertList ? alertList : "");
    }

    @Nonnull
    private String getToolInfo() {
        return String.format(FMT_TOOL_INFO, TOOL_NAME, TOOL_VERSION);
    }

    @Nonnull
    private String getItt2WebVtt(@Nonnull String inputFilePath, @Nonnull String inputFileDescription, @Nonnull String outputFilePath, @Nullable String outputFileDescription, String ... conversionAlerts) {
        StringBuilder concatenated_conversionAlerts = new StringBuilder("");
        if (null != conversionAlerts) {
            for (String entry : conversionAlerts) {
                concatenated_conversionAlerts.append(entry);
            }
        }
        return String.format(FMT_ITT2WEBVTT, inputFilePath, inputFileDescription == null ? "" : inputFileDescription, outputFilePath, null != outputFileDescription ? String.format("<webvtt_file_description>%s</webvtt_file_description>", outputFileDescription) : "", concatenated_conversionAlerts);
    }

    @Nullable
    private String formatAlertList(String ... alerts) {
        if (alerts.length < 1) {
            return null;
        }
        StringBuilder concatenatedAlerts = new StringBuilder("");
        for (String oneAlert : alerts) {
            concatenatedAlerts.append(oneAlert);
        }
        return String.format(FMT_ALERT_LIST, concatenatedAlerts);
    }

    @Nonnull
    private String formatAlert(@Nonnull ValidationLevel level, @Nonnull MediaValidationCode errorCode, @Nonnull String message, @Nullable String dictionary) {
        return String.format(FMT_ALERT, level.name(), errorCode.name(), message, null != dictionary ? dictionary : "");
    }

    @Nonnull
    private String formatAlert(@Nonnull ValidationLevel level, @Nonnull String errorCode, @Nonnull String message, @Nullable String dictionary) {
        return String.format(FMT_ALERT, level.name(), errorCode, message, null != dictionary ? dictionary : "");
    }

    public static SimpleArgParse parseCommandLine(String[] args) throws IllegalArgumentException {
        SimpleArgParse parser = new SimpleArgParse();
        parser.addArgument("input", "i").addArgument("output", "o").addArgument("style", "s", false, "").addArgument("styleformat", "f", false, "json").addArgument("dimensions", "d", false, "").addArgument("tempdir", "t", false, "/private/tmp/runCSA").addFlag("runfromide", "r", false).addFlag("donotConvertCjkVerticalChars", "k", false).parse(args);
        return parser;
    }

    public static void main(String[] args) {
        SimpleArgParse parser = null;
        try {
            parser = ConvertSubtitlesApplication.parseCommandLine(args);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        ConvertSubtitlesApplication.mainWithArguments(parser);
    }

    public static void mainWithArguments(SimpleArgParse args) {
        String outputFileExtension;
        String inputFileExtension;
        boolean convertCjkVerticalChars;
        String inputFilename = args.getArgumentValue("input");
        String outputFilename = args.getArgumentValue("output");
        String outputDimArg = args.getArgumentValue("dimensions");
        String styleFilename = args.getArgumentValue("style");
        String styleFormat = args.getArgumentValue("styleformat");
        boolean bl = convertCjkVerticalChars = !args.isFlagSet("donotConvertCjkVerticalChars");
        if (inputFilename.isEmpty() || outputFilename.isEmpty()) {
            System.err.println(String.format("ERROR: Incorrect number of arguments", new Object[0]));
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        if (!"itt".equalsIgnoreCase(inputFileExtension = FilenameUtils.getExtension((String)inputFilename))) {
            System.err.println(String.format("ERROR: Unknown input file extension %s, only .itt supported", inputFileExtension));
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        if (!"vtt".equalsIgnoreCase(outputFileExtension = FilenameUtils.getExtension((String)outputFilename)) && !"texml".equalsIgnoreCase(outputFileExtension)) {
            System.err.println(String.format("ERROR: Unknown output file extension %s, only .vtt and .texml supported", outputFileExtension));
            System.err.println(TOOL_USAGE);
            System.exit(1);
        }
        dimensions dims = new dimensions(0, 0);
        if ("texml".equalsIgnoreCase(outputFileExtension)) {
            if (Strings.isNullOrEmpty((String)outputDimArg)) {
                System.err.println("ERROR: Missing output dimensions, required for .texml output");
                System.err.printf(TOOL_USAGE, new Object[0]);
                System.exit(1);
            }
            String[] outdimsParts = outputDimArg.split("x");
            try {
                dims.width = Integer.parseInt(outdimsParts[0]);
                dims.height = Integer.parseInt(outdimsParts[1]);
            }
            catch (NumberFormatException ex) {
                System.err.printf("ERROR: Invalid dimensions: %s.", outputDimArg);
                System.err.printf(TOOL_USAGE, new Object[0]);
                System.exit(1);
            }
            if (outdimsParts.length != 2) {
                System.err.printf("ERROR: Invalid dimensions: %s.", outputDimArg);
                System.err.printf(TOOL_USAGE, new Object[0]);
                System.exit(1);
            }
        } else if (!Strings.isNullOrEmpty((String)outputDimArg)) {
            System.err.println(String.format("WARN: For .vtt output, only two arguments supported (first extra argument %s)", outputDimArg));
        }
        ConvertSubtitlesApplication app = new ConvertSubtitlesApplication();
        app.execute(inputFilename, outputFilename, dims, styleFilename, styleFormat, convertCjkVerticalChars);
    }

    @Nonnull
    private String describeFile(@Nonnull String fileToDescribe, @Nonnull ConvSubsValidationContext ittValidationContext) {
        return this.describeFile(fileToDescribe, ittValidationContext, false);
    }

    @Nonnull
    private String describeFile(@Nonnull String fileToDescribe, @Nonnull ConvSubsValidationContext ittValidationContext, boolean addXMLDecl) {
        String fmtForException = FMT_VTT_DESCRIPTION_IN_CASE_OF_EXCEPTION;
        if (fileToDescribe.endsWith(".itt")) {
            fmtForException = FMT_ITT_DESCRIPTION_IN_CASE_OF_EXCEPTION;
        }
        File f = new File(fileToDescribe);
        long fileSize = -1L;
        try {
            fileSize = f.length();
        }
        catch (Exception e) {
            logger.error((Object)String.format("ERROR: Failed to get size of %s:\n%s", fileToDescribe, ExceptionUtils.getStackTrace((Throwable)e)));
            return String.format(fmtForException, -1, String.format("Failed to get size of file %s", fileToDescribe));
        }
        URI uriToDescribe = null;
        try {
            uriToDescribe = fileToDescribe.startsWith("file:/") || fileToDescribe.startsWith("http:/") ? new URI(URIUtil.encodeQuery((String)fileToDescribe, (String)"UTF-8")) : new File(fileToDescribe).toURI();
        }
        catch (Exception ex) {
            logger.error((Object)String.format("ERROR: Failed to get URI for %s:\n%s", fileToDescribe, ExceptionUtils.getStackTrace((Throwable)ex)));
            return String.format(fmtForException, fileSize, String.format("Failed to get URI for file %s", fileToDescribe));
        }
        String descriptionString = "";
        try {
            Node descriptionNode = this.describeApplication.describeFile(uriToDescribe).getDescriptionDocument();
            StringWriter writer = new StringWriter();
            XMLUtil.serializeNode((Node)descriptionNode, (int)2, (Writer)writer, (!addXMLDecl ? 1 : 0) != 0);
            descriptionString = writer.toString();
            if (Strings.isNullOrEmpty((String)descriptionString)) {
                ittValidationContext.addIssue(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, fileToDescribe, MediaUtil.dictionary.add("errorMessage", String.format("Got empty description for file %s", fileToDescribe)));
                return String.format(fmtForException, fileSize, String.format("Got empty description for file %s", fileToDescribe));
            }
        }
        catch (Exception ex) {
            logger.error((Object)String.format("ERROR: Failed to describe %s:\n%s", fileToDescribe, ExceptionUtils.getStackTrace((Throwable)ex)));
            ittValidationContext.addIssue(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, fileToDescribe, MediaUtil.dictionary.add("errorMessage", ex.toString()));
        }
        return descriptionString;
    }

    private void validateInput(@Nonnull String inputFilename, @Nonnull String inputDescription, @Nonnull ConvSubsValidationContext ittValidationContext) {
        try {
            MediaFactory.newMediaFile((MediaFileContext)ittValidationContext, inputDescription);
        }
        catch (XmlException ex) {
            ittValidationContext.addIssue(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, ittValidationContext.getInputFilename(), MediaUtil.dictionary.add("errorMessage", ex.toString()));
        }
        catch (Exception ex) {
            logger.error((Object)String.format("ERROR: Failed to describe %s:\n%s", this._inputFilename, ExceptionUtils.getStackTrace((Throwable)ex)));
            ittValidationContext.addIssue(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, ittValidationContext.getInputFilename(), MediaUtil.dictionary.add("errorMessage", ex.toString()));
        }
    }

    private String formatParameters(SimpleDictionary params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int ii = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(String.format(FMT_ALERT_INFO_LIST_ENTRY, ii++, entry.getValue()));
        }
        if (sb.length() == 0) {
            return "";
        }
        return String.format(FMT_ALERT_INFO_LIST, sb.toString());
    }

    private void reportResults(ConvSubsValidationContext ittValidationContext) {
        ArrayList<String> fmtAlerts = new ArrayList<String>();
        for (ValidationResult issue : ittValidationContext.getValidations()) {
            fmtAlerts.add(this.formatAlert(issue.getValidationLevel(), issue.getValidationCode(), issue.getValidationMessage(), this.formatParameters(issue.getMediaNotificationParameterMap())));
        }
        String infos = this.getItt2WebVtt(ittValidationContext.getInputFilename(), ittValidationContext.getInputDescription(), ittValidationContext.getOutputFilename(), null, new String[0]);
        String report = this.getItt2WebVttInfoString(this.formatAlertList(fmtAlerts.toArray(new String[0])), infos);
        System.out.println(report);
    }

    private void reportAndBailout(@Nonnull ConvSubsValidationContext ittValidationContext, @Nonnull ValidationLevel level, @Nonnull MediaValidationCode errorCode, @Nonnull String message, @Nullable String dictionary) {
        ArrayList<String> fmtAlerts = new ArrayList<String>();
        for (ValidationResult issue : ittValidationContext.getValidations()) {
            fmtAlerts.add(this.formatAlert(issue.getValidationLevel(), issue.getValidationCode(), issue.getValidationMessage(), this.formatParameters(issue.getMediaNotificationParameterMap())));
        }
        String infos = this.getItt2WebVtt(ittValidationContext.getInputFilename(), ittValidationContext.getInputDescription(), ittValidationContext.getOutputFilename(), ittValidationContext.getOutputDescription(), this.formatAlertList(fmtAlerts.toArray(new String[0])));
        String report = this.getItt2WebVttInfoString(this.formatAlertList(this.formatAlert(level, errorCode, message, dictionary)), infos);
        System.out.println(report);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSchema(String filename, ConvSubsValidationContext ittValidationContext) {
        try {
            ValidationError error;
            FileInputStream is = null;
            try {
                is = FileUtils.openInputStream((File)new File(filename));
                TTMLSchemaValidationHelper.validateWithRNCSchema(is, "/com/apple/jingle/leghorn/subtitle/RNC/ttaf1-dfxp.complete.rnc");
            }
            catch (DescriptionException e) {
                try {
                    error = e.getError();
                    ittValidationContext.addIssue(MediaValidationCode.SUBTITLE_FAILS_TTML_SCHEMA_VALIDATION, filename, MediaUtil.dictionary.add("message", error.getUserString()).add("location", error.getLineNumber() + "," + error.getColumn()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
            try {
                is = FileUtils.openInputStream((File)new File(filename));
                TTMLSchemaValidationHelper.validateWithRNCSchema(is, "/com/apple/jingle/leghorn/subtitle/RNC/itunes-timed-text.complete.rnc");
            }
            catch (DescriptionException e) {
                error = e.getError();
                ittValidationContext.addIssue(MediaValidationCode.SUBTITLE_FAILS_ITT_SCHEMA_VALIDATION, filename, MediaUtil.dictionary.add("message", error.getUserString()).add("location", error.getLineNumber() + "," + error.getColumn()));
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (IOException ex) {
            ittValidationContext.addIssue(MediaValidationCode.SUBTITLE_FAILS_SCHEMA_VALIDATION, filename, MediaUtil.dictionary.add("message", "I/O Error"));
        }
        catch (RuntimeException e) {
            ittValidationContext.addIssue(MediaValidationCode.SUBTITLE_FAILS_SCHEMA_VALIDATION, filename, MediaUtil.dictionary.add("message", "XML does not validate").add("location", "1,1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String inputFilename, String outputFilename, dimensions dim, String styleFilename, String styleFileFormat, boolean convertCjkVerticalChars) {
        ConvSubsValidationContext ittValidationContext;
        block20: {
            File outputFile;
            this._inputFilename = inputFilename;
            this._outputFilename = outputFilename;
            ittValidationContext = new ConvSubsValidationContext(this._inputFilename);
            ittValidationContext.setInputFilename(inputFilename);
            ittValidationContext.setOutputFilename(outputFilename);
            this.validateSchema(this._inputFilename, ittValidationContext);
            if (ittValidationContext.hasValidations(ValidationLevel.ERROR)) {
                this.reportResults(ittValidationContext);
                System.exit(1);
            }
            String inputDescription = this.describeFile(this._inputFilename, ittValidationContext);
            if (ittValidationContext.hasValidations(ValidationLevel.ERROR)) {
                this.reportResults(ittValidationContext);
                System.exit(1);
            }
            ittValidationContext.setInputDescription(inputDescription);
            this.validateInput(this._inputFilename, inputDescription, ittValidationContext);
            if (ittValidationContext.hasValidations(ValidationLevel.ERROR)) {
                this.reportResults(ittValidationContext);
                System.exit(1);
            }
            if ((outputFile = new File(this._outputFilename)).exists()) {
                if (!outputFile.canWrite()) {
                    this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_WRITTEN, String.format("File %s cannot be written", this._outputFilename), null);
                }
                if (!outputFile.delete()) {
                    this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_WRITTEN, String.format("File %s cannot be deleted", this._outputFilename), null);
                }
            }
            boolean isVttOutput = false;
            if ("vtt".equalsIgnoreCase(FilenameUtils.getExtension((String)this._outputFilename))) {
                isVttOutput = true;
            }
            ReadableAsset asset = null;
            ittImporterXMLBeans importerXMLBeans = new ittImporterXMLBeans();
            try {
                asset = importerXMLBeans.importToReadableAsset(new File(this._inputFilename), isVttOutput && convertCjkVerticalChars);
            }
            catch (DescriptionException ex) {
                logger.error((Object)String.format("ERROR: Failed to describe %s:\n%s", this._inputFilename, ExceptionUtils.getStackTrace((Throwable)ex)));
                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("File %s cannot be parsed", this._inputFilename), ex.getMessage());
            }
            if (null == asset) {
                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_APPEARS_CORRUPT, String.format("File %s cannot be parsed", this._inputFilename), null);
            }
            try {
                block21: {
                    block22: {
                        if (!isVttOutput) break block21;
                        File styleFile = null;
                        if (Strings.isNullOrEmpty((String)styleFilename)) break block22;
                        styleFile = new File(styleFilename);
                        if (styleFile.exists()) {
                            if (!styleFile.canWrite()) {
                                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_WRITTEN, String.format("File %s cannot be written", this._outputFilename), null);
                            }
                            if (!styleFile.delete()) {
                                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_WRITTEN, String.format("File %s cannot be deleted", this._outputFilename), null);
                            }
                        }
                        WebVTTExporter vttExporter = new WebVTTExporter();
                        vttExporter.setShoulExportStyles(true);
                        File styledVTT = new File(outputFile.getAbsolutePath() + ".tmp");
                        vttExporter.export(asset, styledVTT);
                        VTTStyleParser styleParser = new VTTStyleParser();
                        styleParser.parse(styledVTT);
                        String json = styleParser.getJson();
                        BufferedWriter writer = null;
                        try {
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(styleFile), "UTF-8"));
                            writer.write(json);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(writer);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Writer)writer);
                        FileUtils.deleteQuietly((File)styledVTT);
                        WebVTTExporter vttExporterNoStyleSection = new WebVTTExporter();
                        vttExporterNoStyleSection.setShoulExportStyles(true);
                        vttExporterNoStyleSection.setAddStyleSection(false);
                        vttExporterNoStyleSection.export(asset, outputFile);
                        break block20;
                    }
                    WebVTTExporter vttExporter = new WebVTTExporter();
                    vttExporter.setShoulExportStyles(false);
                    if ("css".equals(styleFileFormat)) {
                        vttExporter.setShoulExportStyles(true);
                    }
                    vttExporter.export(asset, outputFile);
                    break block20;
                }
                texmlExporter exporter = new texmlExporter();
                exporter.setOutputDimensions(dim.width, dim.height);
                exporter.export(asset, outputFile);
            }
            catch (SubtitleConvertException ex) {
                logger.error((Object)String.format("ERROR: Failed to convert %s to %s:\n%s", this._inputFilename, this._inputFilename, ExceptionUtils.getStackTrace((Throwable)ex)));
                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_CONVERTED, String.format("File %s cannot be converted", this._inputFilename), ex.getMessage());
            }
            catch (IOException ex) {
                logger.error((Object)String.format("ERROR: Failed to convert %s to %s:\n%s", this._inputFilename, this._inputFilename, ExceptionUtils.getStackTrace((Throwable)ex)));
                this.reportAndBailout(ittValidationContext, ValidationLevel.ERROR, MediaValidationCode.FILE_CANNOT_BE_CONVERTED, String.format("File %s cannot be converted", this._inputFilename), null);
            }
        }
        String outputDescription = this.describeFile(this._outputFilename, ittValidationContext);
        if (ittValidationContext.hasValidations(ValidationLevel.ERROR)) {
            this.reportResults(ittValidationContext);
            System.exit(1);
        }
        ittValidationContext.setOutputDescription(outputDescription);
        this.reportResults(ittValidationContext);
    }

    static {
        Logger.getRootLogger().setLevel(Level.ERROR);
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), "System.err"));
    }

    static class ValidationErrorLevelCalculator
    implements ValidationLevelCalculator {
        ValidationErrorLevelCalculator() {
        }

        @Override
        @Nonnull
        public ValidationLevel calcLevel(@Nonnull MediaValidationCode code, @Nonnull ValidationLevel defaultLevel, @Nonnull String assetId) {
            return ValidationLevel.ERROR;
        }
    }

    class ConvSubsValidationContext
    extends ITTValidationContext {
        private String _inputFilename;
        private String _outputFilename;
        private String _inputDescription;
        private String _outputDescription;

        public ConvSubsValidationContext(String fileName) {
            super(fileName, "FoghornLeghorn ITT Parser", Configuration.getVersion(), MediaProperties.nullProperties, ValidationLevelCalculator.Common.defaultImplementation);
            this._inputFilename = "";
            this._outputFilename = "";
            this._inputDescription = "";
            this._outputDescription = "";
        }

        public ConvSubsValidationContext(String fileName, String toolName, String toolVersion) {
            super(fileName, toolName, toolVersion);
            this._inputFilename = "";
            this._outputFilename = "";
            this._inputDescription = "";
            this._outputDescription = "";
        }

        public ConvSubsValidationContext(String fileName, String toolName, String toolVersion, MediaProperties mediaProperties, ValidationLevelCalculator levelCalc) {
            super(fileName, toolName, toolVersion, mediaProperties, levelCalc);
            this._inputFilename = "";
            this._outputFilename = "";
            this._inputDescription = "";
            this._outputDescription = "";
        }

        public String getInputFilename() {
            return this._inputFilename;
        }

        public void setInputFilename(String inputFilename) {
            this._inputFilename = inputFilename;
        }

        public String getOutputFilename() {
            return this._outputFilename;
        }

        public void setOutputFilename(String outputFilename) {
            this._outputFilename = outputFilename;
        }

        public String getInputDescription() {
            return this._inputDescription;
        }

        public void setInputDescription(String inputDescription) {
            this._inputDescription = inputDescription;
        }

        public String getOutputDescription() {
            return this._outputDescription;
        }

        public void setOutputDescription(String outputDescription) {
            this._outputDescription = outputDescription;
        }
    }

    static class dimensions {
        public int height = 0;
        public int width = 0;
        public static final dimensions ZERO = new dimensions(0, 0);

        public dimensions(int h, int w) {
            this.height = h;
            this.width = w;
        }
    }
}

