/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.util.URIUtil;

public class ControlCharLocatorApplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws URISyntaxException, IOException {
        if (args.length < 1) {
            System.err.println("You must specify at least one file to find control characters in.");
            return;
        }
        for (String arg : args) {
            URI toDescribe = new URI(URIUtil.encodeQuery((String)arg, (String)"UTF-8"));
            String uriScheme = toDescribe.getScheme();
            if (uriScheme == null) {
                toDescribe = new File(arg).toURI();
            }
            SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)toDescribe);
            SeekableInputStream sis = new SeekableInputStream(sdi);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)sis));){
                String line;
                long lineNumber = 0L;
                long columnNumber = 0L;
                while ((line = br.readLine()) != null) {
                    for (int j = 0; j < line.length(); ++j) {
                        if (Character.isISOControl(line.codePointAt(j))) {
                            System.out.println(String.format("Found a control character (code point: %s) on line %s in column %s", line.codePointAt(j), lineNumber + 1L, columnNumber + 1L));
                        }
                        ++columnNumber;
                    }
                    columnNumber = 0L;
                    ++lineNumber;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

