/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.StreamLocation;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlLineNumber;

public class ConformApplication {
    public static void main(String[] args) throws URISyntaxException, URIException {
        boolean hasFailures = false;
        ArrayList<String> expectedProfiles = new ArrayList<String>();
        ArrayList<URI> files = new ArrayList<URI>();
        String roleToUse = null;
        String utiToUse = null;
        String mimeToUse = null;
        String environment = null;
        for (int i = 0; i < args.length; ++i) {
            if ("--profile".equals(args[i]) || "-p".equals(args[i])) {
                expectedProfiles.add(args[++i]);
                continue;
            }
            if ("--environment".equals(args[i]) || "-e".equals(args[i])) {
                environment = args[++i];
                continue;
            }
            if ("--role".equals(args[i]) || "-r".equals(args[i])) {
                roleToUse = args[++i];
                continue;
            }
            if ("--uti".equals(args[i]) || "-t".equals(args[i])) {
                utiToUse = args[++i];
                continue;
            }
            if ("--mime".equals(args[i]) || "-m".equals(args[i])) {
                mimeToUse = args[++i];
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                System.err.println("USAGE: conform [(-h|--help)] [(-p|--profile) profileName] [(-r|--role) roleToUse] [-t|--uti] utiType] file1 file2 file3...");
                System.exit(1);
                continue;
            }
            String fileName = args[i];
            URI toDescribe = new URI(URIUtil.encodeQuery((String)fileName, (String)"UTF-8"));
            String uriScheme = toDescribe.getScheme();
            if (null == uriScheme) {
                toDescribe = new File(fileName).toURI();
            }
            files.add(toDescribe);
        }
        roleToUse = roleToUse != null ? roleToUse : System.getProperty("com.apple.jingle.leghorn.fileformat.applications.roleToUse");
        utiToUse = utiToUse != null ? utiToUse : System.getProperty("com.apple.jingle.leghorn.fileformat.applications.utiToUse");
        mimeToUse = mimeToUse != null ? mimeToUse : System.getProperty("com.apple.jingle.leghorn.fileformat.applications.mimeToUse");
        environment = environment != null ? environment : System.getProperty("com.apple.jingle.leghorn.fileformat.applications.environment");
        String propertyProfileName = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.profileName");
        if (propertyProfileName != null) {
            expectedProfiles.add(propertyProfileName);
        }
        for (URI toDescribe : files) {
            try {
                Logger.getRootLogger().setLevel(Level.ERROR);
                BasicConfigurator.configure();
                Verifier verifier = LeghornApplicationUtils.getVerifier(environment);
                ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe, roleToUse, utiToUse, mimeToUse);
                ArrayList<String> conformanceProfileNames = expectedProfiles.size() > 0 ? expectedProfiles : new ArrayList<String>(containerType.getConformanceProfileNames());
                Collections.sort(conformanceProfileNames);
                for (String profileName : conformanceProfileNames) {
                    ConformanceResultGatherer gatherer;
                    if (verifier.verifyConformance(toDescribe, containerType, profileName, gatherer = new ConformanceResultGatherer())) {
                        System.out.println("CONFORMS: " + profileName);
                        for (AssertionExplanation ae : gatherer.getSuccesses()) {
                            List<StreamLocation> locations = ae.getLocations();
                            if (locations == null || locations.isEmpty()) continue;
                            System.out.println(String.format("  '%s' returned stream location: %s", ae.getAssertion().getName(), locations));
                        }
                        continue;
                    }
                    hasFailures = true;
                    System.out.println("DOES NOT CONFORM:  " + profileName);
                    System.out.println("ERROR CODE: " + gatherer.getErrorCodes());
                    for (AssertionExplanation ae : gatherer.getFailures()) {
                        System.out.println("  Assertion '" + ae.getAssertion().getName() + "' failed because: ");
                        System.out.println("    " + ae.getFormattedExplanation());
                        if (!ae.getAssertion().getHighlights().isEmpty()) {
                            System.out.println("  Relevant Nodes: " + ae.getAssertion().getHighlights());
                        } else if (!ae.getAssertion().getArguments().isEmpty()) {
                            System.out.println("  Relevant Nodes: " + ae.getAssertion().getArguments());
                        }
                        System.out.print("  Line Numbers: ");
                        for (XmlLineNumber ln : ae.getLineNumbers()) {
                            System.out.print(ln.getLine() + " ");
                        }
                        System.out.println();
                    }
                }
            }
            catch (Exception e) {
                hasFailures = true;
                e.printStackTrace();
            }
        }
        if (hasFailures) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

