/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ContentBasedMimeTypeChecker;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CheckMimeTypeApplication {
    private static final Logger log = Logger.getLogger(CheckMimeTypeApplication.class);

    public boolean checkMimeType(URI toDescribe, String roleToUse, String utiToUse) throws Exception {
        Verifier verifier = Verifier.getDefaultVerifier();
        ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe, roleToUse, utiToUse, null);
        String detectedMimeType = verifier.getMimeTypeBasedOnContent(toDescribe);
        ContentBasedMimeTypeChecker.MimeTypeMatchResult matchResult = verifier.mimeTypeMatches(toDescribe, containerType);
        if (matchResult == ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_DO_NOT_MATCH) {
            log.error((Object)String.format("Specified mime type: %s does not match detected mime type: %s", containerType.getMIMETypeName(), detectedMimeType));
            return false;
        }
        if (matchResult == ContentBasedMimeTypeChecker.MimeTypeMatchResult.FAILED_TO_GET_MIME_TYPE) {
            log.error((Object)String.format("Specified mime type: %s, but failed to detect mime type", containerType.getMIMETypeName()));
            return true;
        }
        if (matchResult == ContentBasedMimeTypeChecker.MimeTypeMatchResult.NO_SPECIFIED_MIME_TYPE) {
            log.error((Object)String.format("No specified mime type (container type: %s), nothing to check against detected mime type %s", containerType.toString(), detectedMimeType));
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws URISyntaxException, VerifierBuilder.UnableToBuildVerifierException, UnknownTypeException, URIException {
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        CheckMimeTypeApplication checkMimeTypeApplication = new CheckMimeTypeApplication();
        try {
            Logger.getRootLogger().getLoggerRepository().resetConfiguration();
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            String roleToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.roleToUse");
            String utiToUse = System.getProperty("com.apple.jingle.leghorn.fileformat.applications.utiToUse");
            if (!checkMimeTypeApplication.checkMimeType(toDescribe, roleToUse, utiToUse)) {
                log.error((Object)String.format("Mime Types do not match: %s", toDescribe));
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
        }
    }
}

