/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.applications;

import com.apple.jingle.leghorn.applications.DescribeApplication;
import com.apple.jingle.leghorn.applications.LeghornApplicationUtils;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceProfile;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BlacklistApplication
extends DescribeApplication {
    public static void main(String[] args) throws URISyntaxException, URIException {
        boolean hasFailures = false;
        URI toDescribe = new URI(URIUtil.encodeQuery((String)args[0], (String)"UTF-8"));
        String uriScheme = toDescribe.getScheme();
        if (null == uriScheme) {
            toDescribe = new File(args[0]).toURI();
        }
        try {
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            Verifier verifier = Verifier.getVerifier("blacklist");
            ContainerType containerType = LeghornApplicationUtils.getContainerType(verifier, toDescribe);
            ArrayList<String> conformanceProfileNames = new ArrayList<String>(containerType.getConformanceProfileNames());
            Collections.sort(conformanceProfileNames);
            for (String profileName : conformanceProfileNames) {
                ConformanceResultGatherer gatherer;
                if (!verifier.verifyConformance(toDescribe, containerType, profileName, gatherer = new ConformanceResultGatherer())) continue;
                ConformanceProfile profile = containerType.getConformanceProfile(profileName);
                System.out.println(args[0] + ": " + profile.getBlacklist().getExplanation());
            }
        }
        catch (Exception e) {
            hasFailures = true;
            e.printStackTrace();
        }
        if (hasFailures) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

