/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn;

import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.ValidationWarning;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.beans.Dictionary;
import com.apple.jingle.leghorn.media.beans.Notification;
import com.apple.jingle.leghorn.media.beans.NotificationList;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationLevelCalculator;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.util.MediaDescriptionHelper;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LeghornValidationContextImpl
implements LeghornValidationContext {
    @Nonnull
    private String fileName;
    @Nonnull
    private final MediaProperties mediaProperties;
    @Nonnull
    private String toolName;
    @Nonnull
    private String toolVersion;
    @Nonnull
    protected final ValidationResultSet alerts;
    @Nonnull
    private final MapDataDump dataDump;
    @Nonnull
    private final UniformTypeIdentifier uti;
    @Nullable
    private final Set<MediaValidationCode> skipValidations;

    public LeghornValidationContextImpl(String fileName, UniformTypeIdentifier uti, String toolName, String toolVersion) {
        this(fileName, uti, toolName, toolVersion, MediaProperties.nullProperties, ValidationLevelCalculator.Common.defaultImplementation);
    }

    public LeghornValidationContextImpl(String fileName, UniformTypeIdentifier uti, String toolName, String toolVersion, MediaProperties mediaProperties, ValidationLevelCalculator levelCalc) {
        this(fileName, uti, toolName, toolVersion, mediaProperties, new ValidationResultSet(levelCalc), new MapDataDump(), null);
    }

    public LeghornValidationContextImpl(String fileName, UniformTypeIdentifier uti, String toolName, String toolVersion, MediaProperties mediaProperties, ValidationResultSet alerts, MapDataDump dataDump, Set<MediaValidationCode> skipValidations) {
        this.fileName = fileName;
        this.toolName = toolName;
        this.toolVersion = toolVersion;
        this.mediaProperties = mediaProperties;
        this.alerts = alerts;
        this.dataDump = dataDump;
        this.uti = uti;
        this.skipValidations = skipValidations;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void settoolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    @Override
    @Nonnull
    public final ValidationResult addCheckAlert(long fileOffset, @Nonnull MediaValidationCode code, @Nonnull SimpleDictionary parameters) {
        return this.alerts.addResult(code, this.fileName + ":" + fileOffset, parameters);
    }

    @Override
    @Nonnull
    public final ValidationResult addCheckAlert(@Nonnull MediaValidationCode code, @Nonnull SimpleDictionary parameters) {
        return this.alerts.addResult(code, this.fileName, parameters);
    }

    @Override
    @Nonnull
    public String getDescriptionToolName() {
        return this.toolName;
    }

    @Override
    @Nonnull
    public String getDescriptionToolVersion() {
        return this.toolVersion;
    }

    @Override
    public void notifyListener(@Nonnull ValidationListener listener) {
        for (ValidationResult result : this.alerts.getValidations(ValidationLevel.INFO)) {
            if (result.getMediaNotificationLevel().asSevereAs(ValidationLevel.ERROR)) {
                listener.error(new ValidationError(result.getDefaultMessage(), result.getMediaNotificationCode()));
                continue;
            }
            if (result.getMediaNotificationLevel().asSevereAs(ValidationLevel.WARNING)) {
                listener.warning(new ValidationWarning(result.getDefaultMessage(), result.getMediaNotificationCode()));
                continue;
            }
            listener.info(new ValidationInfo(result.getDefaultMessage(), result.getMediaNotificationCode()));
        }
    }

    @Override
    public boolean populateAlertList(@Nonnull NotificationList notificationList, @Nonnull ValidationLevel minLevel) {
        List<ValidationResult> results = this.alerts.getValidations(minLevel);
        if (results.isEmpty()) {
            return false;
        }
        for (ValidationResult result : results) {
            String possibleOffset;
            Notification item = notificationList.addNewNotification();
            String name = result.getMediaName();
            if (name.startsWith(this.fileName)) {
                name = name.substring(this.fileName.length());
            }
            String offset = null;
            int sep = name.lastIndexOf(58);
            if (sep != -1 && (possibleOffset = name.substring(sep + 1)).matches("[0-9]+")) {
                offset = possibleOffset;
                name = name.substring(0, sep);
            }
            if (name.length() > 0) {
                item.setAsset(name);
            }
            item.setCode(result.getValidationCode());
            item.setLevel(result.getValidationLevel().name());
            SimpleDictionary resultDictionary = result.getMediaNotificationParameterMap();
            Dictionary dictionary = MediaDescriptionHelper.fromSimpleDictionary(item, resultDictionary);
            if (!resultDictionary.containsKey("message")) {
                MediaDescriptionHelper.add(dictionary, "message", result.getDefaultMessage());
            }
            if (null == offset || offset.length() <= 0 || resultDictionary.containsKey("offset")) continue;
            MediaDescriptionHelper.add(dictionary, "offset", offset);
        }
        return true;
    }

    @Override
    public boolean hasValidations(MediaValidationCode ... codes) {
        return this.alerts.hasValidations(codes);
    }

    @Override
    public boolean hasValidations(ValidationLevel minLevel) {
        return this.alerts.hasValidations(minLevel);
    }

    @Override
    public Collection<ValidationResult> getValidations() {
        return this.alerts.getValidations();
    }

    @Override
    public Collection<ValidationResult> getValidations(@Nonnull ValidationLevel minLevel) {
        return this.alerts.getValidations(minLevel);
    }

    @Override
    public Collection<ValidationResult> getValidations(MediaValidationCode ... codes) {
        return this.alerts.getValidations(codes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.alerts;
    }

    @Override
    public MapDataDump dataDump() {
        return this.dataDump;
    }

    @Override
    public LeghornValidationContext child(@Nonnull String childLabel) {
        return new LeghornValidationContextImpl(this.fileName, this.uti, this.toolName, this.toolVersion, this.mediaProperties, this.alerts, this.dataDump.child(childLabel), this.skipValidations);
    }

    @Override
    public String getMediaName() {
        return this.fileName;
    }

    @Override
    @Nullable
    public String getMediaLocale() {
        return null;
    }

    @Override
    public ValidationResult addIssue(MediaValidationCode code, String assetId, SimpleDictionary parameters) {
        return this.alerts.addResult(code, assetId, parameters);
    }

    @Override
    public ValidationResult addIssue(MediaValidationCode code, ValidationLevel defaultLevel, String assetId, SimpleDictionary parameters) {
        return this.alerts.addResult(code, defaultLevel, assetId, parameters);
    }

    @Override
    @Nonnull
    public UniformTypeIdentifier getUniformTypeIdentifier() {
        return this.uti;
    }

    @Override
    public Map<String, String> getMediaAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public MediaProperties getMediaProperties() {
        return this.mediaProperties;
    }

    @Override
    public Set<MediaValidationCode> getSkipValidations() {
        return this.skipValidations;
    }
}

