/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5.util;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StringDataDump
implements Closeable,
DataDump {
    private static final String indentString = "                                     ";
    private static final int indentWidth = 2;
    @Nonnull
    private final StringWriter stringWriter;
    @Nonnull
    private final PrintWriter out;
    @Nullable
    private final StringDataDump parent;
    @Nonnegative
    private final int indentLevel;
    @Nullable
    private StringDataDump child;
    private boolean open = true;

    public StringDataDump() {
        this.parent = null;
        this.indentLevel = 0;
        this.stringWriter = new StringWriter();
        this.out = new PrintWriter((Writer)this.stringWriter, true);
    }

    private StringDataDump(@Nonnull StringDataDump parent, @Nonnegative int indentLevel) {
        this.parent = parent;
        this.stringWriter = parent.stringWriter;
        this.out = parent.out;
        this.indentLevel = indentLevel;
    }

    @Override
    public Level level() {
        return Level.INFO;
    }

    private final void println(String line) {
        int toWrite;
        if (null != this.child) {
            throw new IllegalStateException("Cannot write to parent DataDump while child is open");
        }
        if (!this.open) {
            throw new IllegalStateException("Cannot write to closed DataDump");
        }
        for (int toIndent = this.indentLevel * 2; toIndent > 0; toIndent -= toWrite) {
            toWrite = Math.min(toIndent, indentString.length());
            this.out.print(indentString.substring(0, toWrite));
        }
        this.out.println(line);
    }

    @Override
    @Nonnull
    public StringDataDump child(@Nonnull Class<?> childLabel) {
        return this.child(childLabel.getSimpleName());
    }

    @Override
    @Nonnull
    public StringDataDump child(@Nonnull String childLabel) {
        this.println(childLabel + "[");
        this.child = new StringDataDump(this, this.indentLevel + 1);
        return this.child;
    }

    public String toString() {
        return this.stringWriter.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void handleChildClose() {
        if (null != this.child) {
            this.child = null;
            this.println("]");
        }
    }

    @Override
    public void close() {
        if (this.open) {
            if (null == this.parent) {
                this.out.close();
            } else {
                this.parent.handleChildClose();
            }
            this.open = false;
        }
    }

    @Override
    @Nonnull
    public DataDump write(@Nonnull String key, boolean booleanValue) {
        if (booleanValue) {
            this.println(key);
        }
        return this;
    }

    @Override
    @Nonnull
    public final DataDump write(@Nonnull String key, @Nullable Object value) {
        return this.write(key, null != value, value);
    }

    @Override
    @Nonnull
    public DataDump write(@Nonnull String key, boolean condition, @Nullable Object value) {
        if (condition) {
            this.println(key + ": " + value);
        }
        return this;
    }

    @Override
    public DataDump write(@Nonnull String key, @Nullable Collection<?> values) {
        if (values != null && !values.isEmpty()) {
            return this.write(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump write(@Nonnull String key, boolean condition, @Nullable Collection<?> values) {
        if (!condition || null == values) {
            return this;
        }
        try (StringDataDump child = this.child(key);){
            int idx = 0;
            for (Object v : values) {
                child.write(Integer.toString(++idx), true, v);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public final DataDump dump(@Nonnull String key, @Nullable DataDumpable value) {
        return this.dump(key, null != value, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public DataDump dump(@Nonnull String key, boolean condition, @Nullable DataDumpable value) {
        if (condition) {
            try (StringDataDump child = this.child(key);){
                if (null != value) {
                    value.dumpData(child);
                }
            }
        }
        return this;
    }

    @Override
    public DataDump dump(String key, Collection<? extends DataDumpable> values) {
        if (values != null && !values.isEmpty()) {
            return this.dump(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump dump(String key, boolean condition, Collection<? extends DataDumpable> values) {
        if (!condition || null == values) {
            return this;
        }
        try (StringDataDump child = this.child(key);){
            int idx = 0;
            for (DataDumpable dataDumpable : values) {
                child.dump(Integer.toString(++idx), dataDumpable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final String toString(@Nonnull DataDumpable dumpable) {
        try (StringDataDump dump = new StringDataDump();){
            dumpable.dumpData(dump);
        }
        return dump.toString();
    }
}

